/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widgets;

import java.util.LinkedHashMap;
import java.util.Map;
import mcp.mobius.waila.gui.events.MouseEvent;
import mcp.mobius.waila.gui.helpers.ReverseIterator;
import mcp.mobius.waila.gui.interfaces.CType;
import mcp.mobius.waila.gui.interfaces.IWidget;
import mcp.mobius.waila.gui.interfaces.RenderPriority;
import mcp.mobius.waila.gui.interfaces.Signal;
import mcp.mobius.waila.gui.widgets.WidgetGeometry;
import mcp.mobius.waila.utils.GLState;
import net.minecraft.client.Minecraft;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.ScaledResolution;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public abstract class WidgetBase
implements IWidget {
    protected IWidget parent;
    protected WidgetGeometry geom;
    protected Map<String, IWidget> widgets = new LinkedHashMap<String, IWidget>();
    protected Map<String, IWidget> renderQueue_HIGH = new LinkedHashMap<String, IWidget>();
    protected Map<String, IWidget> renderQueue_MEDIUM = new LinkedHashMap<String, IWidget>();
    protected Map<String, IWidget> renderQueue_LOW = new LinkedHashMap<String, IWidget>();
    protected Minecraft mc;
    protected RenderEngine renderEngine;
    protected ScaledResolution rez;
    protected boolean hasBlending;
    protected boolean hasLight;
    protected int boundTexIndex;
    protected boolean isRendering = true;
    protected float alpha = 1.0f;

    public WidgetBase(IWidget parent) {
        this.setParent(parent);
        this.mc = Minecraft.getMinecraft();
        this.rez = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        this.renderEngine = this.mc.renderEngine;
        this.setGeometry(new WidgetGeometry(0.0, 0.0, 50.0, 50.0, CType.ABSXY, CType.ABSXY));
    }

    @Override
    public IWidget addWidget(String name, IWidget widget) {
        return this.addWidget(name, widget, RenderPriority.MEDIUM);
    }

    @Override
    public IWidget addWidget(String name, IWidget widget, RenderPriority priority) {
        widget.setParent(this);
        this.widgets.put(name, widget);
        switch (priority) {
            case LOW: {
                this.renderQueue_LOW.put(name, widget);
                break;
            }
            case HIGH: {
                this.renderQueue_HIGH.put(name, widget);
                break;
            }
            case MEDIUM: {
                this.renderQueue_MEDIUM.put(name, widget);
            }
        }
        return this.getWidget(name);
    }

    @Override
    public IWidget getWidget(String name) {
        return this.widgets.get(name);
    }

    @Override
    public IWidget delWidget(String name) {
        IWidget widget = this.getWidget(name);
        this.widgets.values().remove(widget);
        return widget;
    }

    @Override
    public IWidget getWidgetAtCoordinates(double posX, double posY) {
        for (IWidget widget : new ReverseIterator<IWidget>(this.widgets.values())) {
            if (!(posX >= (double)widget.getPos().getX()) || !(posX <= (double)(widget.getPos().getX() + widget.getSize().getX())) || !(posY >= (double)widget.getPos().getY()) || !(posY <= (double)(widget.getPos().getY() + widget.getSize().getY()))) continue;
            return widget.getWidgetAtCoordinates(posX, posY);
        }
        if (posX >= (double)this.getPos().getX() && posX <= (double)(this.getPos().getX() + this.getSize().getX()) && posY >= (double)this.getPos().getY() && posY <= (double)(this.getPos().getY() + this.getSize().getY())) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isWidgetAtCoordinates(double posx, double posy) {
        if ((double)this.getLeft() > posx) {
            return false;
        }
        if ((double)this.getRight() < posx) {
            return false;
        }
        if ((double)this.getTop() > posy) {
            return false;
        }
        return !((double)this.getBottom() < posy);
    }

    @Override
    public IWidget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IWidget parent) {
        this.parent = parent;
    }

    @Override
    public void draw() {
        GLState state = new GLState();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.draw(this.getPos());
        for (IWidget widget : this.renderQueue_LOW.values()) {
            if (!widget.shouldRender()) continue;
            widget.draw();
        }
        for (IWidget widget : this.renderQueue_MEDIUM.values()) {
            if (!widget.shouldRender()) continue;
            widget.draw();
        }
        for (IWidget widget : this.renderQueue_HIGH.values()) {
            if (!widget.shouldRender()) continue;
            widget.draw();
        }
        state.reset();
    }

    @Override
    public abstract void draw(Point var1);

    @Override
    public IWidget setGeometry(WidgetGeometry geom) {
        this.geom = geom;
        this.emit(Signal.GEOM_CHANGED, this.geom);
        return this;
    }

    public IWidget setGeometry(double x, double y, double sx, double sy, CType fp, CType fs) {
        this.setGeometry(new WidgetGeometry(x, y, sx, sy, fp, fs));
        this.emit(Signal.GEOM_CHANGED, this.geom);
        return this;
    }

    @Override
    public WidgetGeometry getGeometry() {
        return this.geom;
    }

    @Override
    public Point getPos() {
        return this.geom.getPos(this.parent);
    }

    @Override
    public Point getSize() {
        return this.geom.getSize(this.parent);
    }

    @Override
    public int getLeft() {
        return this.getPos().getX();
    }

    @Override
    public int getRight() {
        return this.getPos().getX() + this.getSize().getX();
    }

    @Override
    public int getTop() {
        return this.getPos().getY();
    }

    @Override
    public int getBottom() {
        return this.getPos().getY() + this.getSize().getY();
    }

    @Override
    public IWidget setPos(double x, double y) {
        return this.setPos(x, y, this.geom.fracPosX, this.geom.fracPosY);
    }

    @Override
    public IWidget setPos(double x, double y, boolean fracX, boolean fracY) {
        this.geom.setPos(x, y, fracX, fracY);
        this.emit(Signal.GEOM_CHANGED, this.geom);
        return this;
    }

    @Override
    public IWidget setSize(double sx, double sy) {
        return this.setSize(sx, sy, this.geom.fracSizeX, this.geom.fracSizeY);
    }

    @Override
    public IWidget setSize(double sx, double sy, boolean fracX, boolean fracY) {
        this.geom.setSize(sx, sy, fracX, fracY);
        this.emit(Signal.GEOM_CHANGED, this.geom);
        return this;
    }

    @Override
    public IWidget adjustSize() {
        int minleft = 9999;
        int maxright = 0;
        int mintop = 9999;
        int maxbottom = 0;
        for (IWidget widget : this.widgets.values()) {
            minleft = Math.min(minleft, widget.getLeft());
            maxright = Math.max(maxright, widget.getRight());
            mintop = Math.min(mintop, widget.getTop());
            maxbottom = Math.max(maxbottom, widget.getBottom());
        }
        this.setSize(maxright - minleft, maxbottom - mintop, false, false);
        this.emit(Signal.GEOM_CHANGED, this.geom);
        return this;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void show() {
        this.isRendering = true;
    }

    @Override
    public void hide() {
        this.isRendering = false;
    }

    @Override
    public boolean shouldRender() {
        return this.isRendering;
    }

    @Override
    public void handleMouseInput() {
    }

    @Override
    public void onMouseClick(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseClick(event);
        }
    }

    @Override
    public void onMouseDrag(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseDrag(event);
        }
    }

    @Override
    public void onMouseMove(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseMove(event);
        }
    }

    @Override
    public void onMouseRelease(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseRelease(event);
        }
    }

    @Override
    public void onMouseWheel(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseWheel(event);
        }
    }

    @Override
    public void onMouseEnter(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseEnter(event);
        }
    }

    @Override
    public void onMouseLeave(MouseEvent event) {
        if (this.parent != null) {
            this.parent.onMouseLeave(event);
        }
    }

    @Override
    public void emit(Signal signal, Object ... params) {
        if (this.parent != null) {
            this.parent.onWidgetEvent(this, signal, params);
        }
    }

    @Override
    public void onWidgetEvent(IWidget srcwidget, Signal signal, Object ... params) {
        if (this.parent != null) {
            this.parent.onWidgetEvent(srcwidget, signal, params);
        }
    }
}

