/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import java.util.Random;
import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ConstantRandom;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public ii getStack(IDataAccessor accessor, IPluginConfig config) {
        to block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.redstone) {
            return new ii(gb.aA);
        }
        if (block instanceof bl) {
            return new ii(to.aN);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new ii(gb.aZ);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new ii(gb.aH);
        }
        if (block == VanillaPlugin.crops) {
            return new ii(gb.R);
        }
        if (block == VanillaPlugin.bed) {
            return new ii(gb.aY);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new ii(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new ii(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(ii itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        to block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof cq && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((cq)accessor.getTileEntity()).a();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block instanceof xi) {
            currenttip.set(0, "\u00a7f" + DisplayUtil.itemDisplayNameShort(new ii(block.a(accessor.getMetadata(), (Random)ConstantRandom.INSTANCE), 1, accessor.getMetadata() > 3 ? 0 : accessor.getMetadata())));
        }
        if (block == VanillaPlugin.web) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.web.name", new Object[0]));
        }
    }

    @Override
    public void modifyBody(ii itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        to block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            my tag = accessor.getNBTData();
            gb record = null;
            if (meta != 0) {
                record = gb.c[gb.bb.bd + meta - 1];
            }
            try {
                currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + VanillaPlugin.ItemRecord_recordName.get(record));
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, block.getClass().getName() + ":" + meta, currenttip);
            }
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            ty mop = accessor.getPosition();
            kr m2 = accessor.getWorld().f(mop.b, mop.c - 1, mop.d);
            String instrument = "hud.msg.piano";
            if (m2 == kr.d) {
                instrument = "hud.msg.bass_drum";
            } else if (m2 == kr.m) {
                instrument = "hud.msg.snare_drum";
            } else if (m2 == kr.o) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m2 == kr.c) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(ii itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(nx te, my tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

