/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import mcp.mobius.waila.api.ITaggedList;

public final class WailaExceptionHandler {
    private static final Set<String> errs = new HashSet<String>();

    private WailaExceptionHandler() {
        throw new UnsupportedOperationException();
    }

    public static void handleErr(Throwable t2, Class<?> context, ITaggedList<String, String> currenttip) {
        WailaExceptionHandler.handleErr(t2, context.getName(), currenttip);
    }

    public static void handleErr(Throwable t2, String context, ITaggedList<String, String> currenttip) {
        if (!errs.contains(context)) {
            errs.add(context);
            block0: for (Throwable working = t2; working != null; working = working.getCause()) {
                if (working != t2) {
                    mod_BlockHelper.LOG.log(Level.WARNING, "Caused by: " + working);
                }
                for (StackTraceElement elem : working.getStackTrace()) {
                    mod_BlockHelper.LOG.log(Level.WARNING, elem.getClassName() + "." + elem.getMethodName() + ":" + elem.getLineNumber());
                    if (working == t2 && elem.getClassName().contains("waila")) continue block0;
                }
            }
            mod_BlockHelper.LOG.log(Level.WARNING, "Caught unhandled exception: [" + context + "] " + t2);
        }
        if (currenttip != null) {
            currenttip.add("<ERROR>");
        }
    }
}

