/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc2;

import mcp.mobius.waila.addons.bc2.BC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerBC2Energy
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBC2Energy();

    private HUDHandlerBC2Energy() {
    }

    @Override
    public yq getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get("bcapi.storage")) {
            return;
        }
        if (!accessor.getNBTData().c("MJEnergy")) {
            return;
        }
        int energy = accessor.getNBTInteger("MJEnergy");
        int maxEnergy = accessor.getNBTInteger("MJMaxStorage");
        try {
            if (maxEnergy > 0 && currenttip.getEntries("MJEnergyStorage").isEmpty()) {
                String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(energy, maxEnergy) + "\u00a7r" + " / " + "\u00a7f" + maxEnergy + "\u00a7r" + " MJ", "MJEnergyStorage");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(kf te, abx tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            Object prov;
            int energy = -1;
            int maxsto = -1;
            if (BC2Plugin.TileEngine.isInstance(te)) {
                Object engine = BC2Plugin.TileEngine_engine.get(te);
                if (engine != null) {
                    energy = BC2Plugin.Engine_energy.getInt(engine);
                    maxsto = BC2Plugin.Engine_maxEnergy.getInt(engine);
                }
            } else if (BC2Plugin.IPowerReceptor.isInstance(te) && (prov = BC2Plugin.IPowerReceptor_getPowerProvider.invoke((Object)te, new Object[0])) != null) {
                energy = BC2Plugin.PowerProvider_energyStored.getInt(prov);
                maxsto = BC2Plugin.PowerProvider_maxEnergyStored.getInt(prov);
            }
            tag.a("MJEnergy", energy);
            tag.a("MJMaxStorage", maxsto);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

