/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc2;

import mcp.mobius.waila.addons.bc2.LiquidHelper;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerEntityAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerEntityBC2Tanks
implements IEntityProvider {
    public static final IEntityProvider INSTANCE = new HUDHandlerEntityBC2Tanks();

    private HUDHandlerEntityBC2Tanks() {
    }

    @Override
    public ms getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public yq getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ms entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tanktype")) {
                int liquidId = accessor.getNBTInteger("liquidtype");
                int capacity = accessor.getNBTInteger("liquidcapacity");
                if (capacity > 0) {
                    String name = (String)currenttip.get(0);
                    name = name + " " + (liquidId == 0 ? I18n.translate("hud.msg.empty", new Object[0]) : "(" + LiquidHelper.getLiquidName(liquidId) + "\u00a7r" + "\u00a7f" + ")");
                    currenttip.set(0, name);
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyBody(ms entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tankamount")) {
                int liquidAmount = accessor.getNBTInteger("liquidamt");
                int capacity = accessor.getNBTInteger("liquidcapacity");
                if (capacity > 0) {
                    currenttip.add(liquidAmount + "/" + capacity + " mB");
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(ms entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(ms ent, abx tag, IServerEntityAccessor accessor, IPluginConfig config) {
        LiquidHelper.writeToNBT(ent, tag);
    }
}

