/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import java.util.Random;
import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ConstantRandom;
import mcp.mobius.waila.utils.I18n;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public yq getStack(IDataAccessor accessor, IPluginConfig config) {
        oe block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.silverfish && config.get("vanilla.silverfish")) {
            switch (meta) {
                case 1: {
                    return new yq(oe.y);
                }
                case 2: {
                    return new yq(oe.bo);
                }
            }
            return new yq(oe.v);
        }
        if (block == VanillaPlugin.redstone) {
            return new yq(ww.aC);
        }
        if (block instanceof tf) {
            return new yq(oe.aP);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new yq(ww.bb);
        }
        if (block == VanillaPlugin.melonStem) {
            return new yq(ww.bh);
        }
        if (block == VanillaPlugin.pumpkinStem) {
            return new yq(ww.bg);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new yq(ww.aJ);
        }
        if (block == VanillaPlugin.crops) {
            return new yq(ww.T);
        }
        if (block == VanillaPlugin.cauldron) {
            return new yq(ww.bz);
        }
        if (block == VanillaPlugin.bed) {
            return new yq(ww.ba);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new yq(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new yq(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        oe block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof cd && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((cd)accessor.getTileEntity()).a();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.melonStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.melonStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.pumpkinStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pumpkinStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.endPortal) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.endPortal.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
        if (block instanceof ajr) {
            currenttip.set(0, "\u00a7f" + DisplayUtil.itemDisplayNameShort(new yq(block.a(accessor.getMetadata(), (Random)ConstantRandom.INSTANCE, 0), 1, mod_BlockHelper.Accessor.damageDropped(block, accessor.getMetadata()))));
        }
        if (block == VanillaPlugin.silverfish && !config.get("vanilla.silverfish")) {
            switch (accessor.getMetadata()) {
                case 1: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.cobble.name", new Object[0]));
                    break;
                }
                case 2: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.brick.name", new Object[0]));
                    break;
                }
                default: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.stone.name", new Object[0]));
                }
            }
        }
    }

    @Override
    public void modifyBody(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        oe block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            abx tag = accessor.getNBTData();
            ww record = null;
            if (tag.c("RecordItem")) {
                yq stack = yq.a((abx)tag.l("RecordItem"));
                ww ww2 = record = stack == null ? null : stack.a();
            }
            if (record == null && tag.c("Record")) {
                record = ww.e[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + ((afy)record).a);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            on mop = accessor.getPosition();
            aan m = accessor.getWorld().f(mop.b, mop.c - 1, mop.d);
            String instrument = "hud.msg.piano";
            if (m == aan.e) {
                instrument = "hud.msg.bass_drum";
            } else if (m == aan.o) {
                instrument = "hud.msg.snare_drum";
            } else if (m == aan.q) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == aan.d) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(yq itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(kf te, abx tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

