/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.WailaDirection;
import mcp.mobius.waila.utils.NBTUtil;

public class DataAccessorCommon
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public vq world;
    public xb player;
    public on mop;
    public bk renderingvec = null;
    public oe block;
    public int blockID;
    public int metadata;
    public kf tileEntity;
    public ms entity;
    public abx remoteNbt = new abx();
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public yq stack;
    public static final DataAccessorCommon INSTANCE = new DataAccessorCommon();

    public void set(vq _world, xb _player, on _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(vq _world, xb _player, on _mop, aar viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop == null) {
            this.renderingvec = null;
            this.block = null;
            this.blockID = 0;
            this.metadata = 0;
            this.tileEntity = null;
            this.entity = null;
            this.remoteNbt = new abx();
            this.timeLastUpdate = System.currentTimeMillis();
            this.partialFrame = 0.0;
            this.stack = null;
        } else {
            if (this.mop.a == yw.a) {
                this.blockID = this.world.a(this.mop.b, this.mop.c, this.mop.d);
                this.metadata = this.world.e(this.mop.b, this.mop.c, this.mop.d);
                this.block = oe.m[this.blockID];
                this.tileEntity = this.world.b(this.mop.b, this.mop.c, this.mop.d);
                this.entity = null;
                try {
                    this.stack = new yq(this.block, 1, this.metadata);
                }
                catch (Throwable ignored) {}
            } else if (this.mop.a == yw.b) {
                this.block = null;
                this.metadata = -1;
                this.tileEntity = null;
                this.stack = null;
                this.entity = this.mop.g;
            }
            if (viewEntity != null) {
                double px = viewEntity.N + (viewEntity.o - viewEntity.N) * partialTicks;
                double py = viewEntity.O + (viewEntity.p - viewEntity.O) * partialTicks;
                double pz = viewEntity.P + (viewEntity.q - viewEntity.P) * partialTicks;
                this.renderingvec = bk.a((double)((double)this.mop.b - px), (double)((double)this.mop.c - py), (double)((double)this.mop.d - pz));
                this.partialFrame = partialTicks;
            }
        }
    }

    public void clear() {
        this.set(null, null, null);
    }

    @Override
    public vq getWorld() {
        return this.world;
    }

    @Override
    public xb getPlayer() {
        return this.player;
    }

    @Override
    public oe getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public kf getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public ms getEntity() {
        return this.entity;
    }

    @Override
    public on getPosition() {
        return this.mop;
    }

    @Override
    public bk getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public abx getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            abx tag = new abx();
            try {
                this.tileEntity.b(tag);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            abx tag = new abx();
            try {
                this.entity.d(tag);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        return new abx();
    }

    public void setNBTData(abx tag) {
        if (tag != null) {
            this.remoteNbt = tag;
        }
    }

    private boolean isTagCorrectTileEntity(abx tag) {
        if (!(tag != null && tag.c("WailaX") && tag.c("WailaY") && tag.c("WailaZ"))) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.f("WailaX");
        int y = tag.f("WailaY");
        int z = tag.f("WailaZ");
        if (x == this.mop.b && y == this.mop.c && z == this.mop.d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(abx tag) {
        if (tag == null || !tag.c("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.f("WailaEntityID");
        if (id == this.entity.f) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(String keyname) {
        return this.getNBTInteger(this.getNBTData(), keyname);
    }

    @Override
    public int getNBTInteger(abx tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public WailaDirection getSide() {
        return WailaDirection.getOrientation(this.getPosition().e);
    }

    @Override
    public yq getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

