/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class HUDHandlerElecMachine
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerElecMachine();

    private HUDHandlerElecMachine() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic2.storage")) {
            try {
                int storage = accessor.getNBTInteger("energy");
                int maxStorage = accessor.getNBTInteger("maxStorage");
                String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
                if (maxStorage > 0) {
                    currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " EU");
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            if (IC2Plugin.IEnergyStorage.isInstance(te)) {
                return;
            }
            if (IC2Plugin.TileBaseGenerator.isInstance(te)) {
                return;
            }
            int maxStorage = -1;
            if (IC2Plugin.TileEntityElecMachine.isInstance(te)) {
                maxStorage = IC2Plugin.TileEntityElecMachine_maxEnergy.getInt(te);
            }
            tag.setInteger("maxStorage", maxStorage);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, te.getClass(), null);
        }
    }
}

