/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlowerPot;
import net.minecraft.src.BlockRedstoneOre;
import net.minecraft.src.Item;
import net.minecraft.src.ItemRecord;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Potion;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntitySkull;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.silverfish && config.get("vanilla.silverfish")) {
            switch (meta) {
                case 1: {
                    return new ItemStack(Block.cobblestone);
                }
                case 2: {
                    return new ItemStack(Block.stoneBrick);
                }
            }
            return new ItemStack(Block.stone);
        }
        if (block == VanillaPlugin.redstone) {
            return new ItemStack(Item.redstone);
        }
        if (block instanceof BlockRedstoneOre) {
            return new ItemStack(Block.oreRedstone);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new ItemStack(Item.redstoneRepeater);
        }
        if (block == VanillaPlugin.melonStem) {
            return new ItemStack(Item.melonSeeds);
        }
        if (block == VanillaPlugin.pumpkinStem) {
            return new ItemStack(Item.pumpkinSeeds);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new ItemStack(Item.reed);
        }
        if (block == VanillaPlugin.crops) {
            return new ItemStack(Item.wheat);
        }
        if (block == VanillaPlugin.carrot) {
            return new ItemStack(Item.field_82797_bK);
        }
        if (block == VanillaPlugin.potato) {
            return new ItemStack(Item.field_82794_bL);
        }
        if (block == VanillaPlugin.flowerPot) {
            return new ItemStack(Item.field_82796_bJ);
        }
        if (block == VanillaPlugin.cauldron) {
            return new ItemStack(Item.cauldron);
        }
        if (block == VanillaPlugin.bed) {
            return new ItemStack(Item.bed);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new ItemStack(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new ItemStack(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).getMobID();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.melonStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.melonStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.pumpkinStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pumpkinStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.endPortal) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.endPortal.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        String playerName;
        TileEntitySkull te;
        ItemStack flower;
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            Item record = null;
            if (tag.hasKey("RecordItem")) {
                ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("RecordItem"));
                Item item = record = stack == null ? null : stack.getItem();
            }
            if (record == null && tag.hasKey("Record")) {
                record = Item.itemsList[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + ((ItemRecord)record).recordName);
        }
        if (config.get("vanilla.flowerpot") && block == VanillaPlugin.flowerPot && (flower = BlockFlowerPot.func_82531_c((int)meta)) != null) {
            currenttip.add(I18n.translate("hud.msg.flower", new Object[0]) + ": " + DisplayUtil.itemDisplayNameShort(flower));
        }
        if (config.get("vanilla.skull") && accessor.getTileEntity() instanceof TileEntitySkull && (te = (TileEntitySkull)accessor.getTileEntity()).func_82117_a() == 3 && (playerName = te.func_82120_c()) != null && !playerName.isEmpty()) {
            currenttip.add(I18n.translate("hud.msg.head_owner", new Object[0]) + ": " + playerName);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            MovingObjectPosition mop = accessor.getPosition();
            Material m = accessor.getWorld().getBlockMaterial(mop.blockX, mop.blockY - 1, mop.blockZ);
            String instrument = "hud.msg.piano";
            if (m == Material.rock) {
                instrument = "hud.msg.bass_drum";
            } else if (m == Material.sand) {
                instrument = "hud.msg.snare_drum";
            } else if (m == Material.glass) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == Material.wood) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
        if (config.get("vanilla.beacon") && block == VanillaPlugin.beacon) {
            int level = accessor.getNBTInteger("Levels");
            int primary = accessor.getNBTInteger("Primary");
            int secondary = accessor.getNBTInteger("Secondary");
            if (level >= 0) {
                currenttip.add(I18n.translate("hud.msg.level", new Object[0]) + ": " + level);
            }
            if (primary > 0) {
                currenttip.add(I18n.translate("hud.msg.primary_effect", new Object[0]) + ": " + I18n.translate(Potion.potionTypes[primary].getName(), new Object[0]));
            }
            if (secondary > 0) {
                currenttip.add(I18n.translate("hud.msg.secondary_effect", new Object[0]) + ": " + I18n.translate(Potion.potionTypes[secondary].getName(), new Object[0]));
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

