/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.src.mod_BlockHelper;

public class BlockHelperUpdater
implements Runnable {
    private static final String JSON_URL = "https://raw.githubusercontent.com/ThexXTURBOXx/UpdateJSONs/master/block-helper.csv";
    public boolean notify = false;
    private Status status = Status.NOT_STARTED;
    private String latestVersion = "";

    @Override
    public void run() {
        try {
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            List<String> latestVersions = this.getLatestModVersions(new URL(JSON_URL).openStream());
            if (latestVersions.isEmpty()) {
                throw new IllegalStateException("Version not found.");
            }
            this.latestVersion = latestVersions.get(0);
            Status status = this.status = latestVersions.contains("2.0.0-pre1") ? Status.UP_TO_DATE : Status.OUTDATED;
            if (this.status == Status.UP_TO_DATE) {
                mod_BlockHelper.LOG.info(String.format("Yay! You have the newest version of %s :)", "Block Helper"));
            } else {
                mod_BlockHelper.LOG.info(String.format("Newer version of %s available: %s", "Block Helper", this.latestVersion));
            }
        }
        catch (Throwable t) {
            this.status = Status.ERRORED;
            mod_BlockHelper.LOG.log(Level.WARNING, String.format("Update check for %s failed.", "Block Helper"), t);
        }
    }

    public String getLatestVersion() {
        if (this.latestVersion.isEmpty()) {
            this.latestVersion = "2.0.0-pre1";
        }
        return this.latestVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLatestModVersions(InputStream is) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split(",");
                if (!"b1.3_01".equals(split[0])) continue;
                versions.add(split[1]);
            }
        }
        finally {
            is.close();
            isr.close();
            br.close();
        }
        return versions;
    }

    public static enum Status {
        NOT_STARTED,
        ERRORED,
        OUTDATED,
        UP_TO_DATE;

    }
}

