/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc2;

import buildcraft.api.ILiquidContainer;
import buildcraft.api.LiquidSlot;
import java.lang.reflect.Method;
import java.util.logging.Level;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.AccessHelper;
import mcp.mobius.waila.utils.I18n;

public final class LiquidHelper {
    private static Method ILiquidContainer_getCapacity;

    private LiquidHelper() {
        throw new UnsupportedOperationException();
    }

    public static void writeToNBT(Object container, xb tag) {
        LiquidSlot slot = LiquidHelper.getTank((ILiquidContainer)container);
        int liquidId = slot != null ? slot.getLiquidId() : 0;
        int liquidAmount = slot != null ? slot.getLiquidQty() : 0;
        int capacity = slot != null ? slot.getCapacity() : 0;
        tag.a("liquidtype", liquidId);
        tag.a("liquidamt", liquidAmount);
        tag.a("liquidcapacity", capacity);
    }

    public static LiquidSlot getTank(ILiquidContainer container) {
        try {
            int quantity;
            int capacity = quantity = container.getLiquidQuantity();
            try {
                capacity = Math.max(capacity, ILiquidContainer_getCapacity != null ? (Integer)ILiquidContainer_getCapacity.invoke((Object)container, new Object[0]) : 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (capacity > 0) {
                return new LiquidSlot(container.getLiquidId(), quantity, capacity);
            }
        }
        catch (Throwable t) {
            mod_BlockHelper.LOG.log(Level.SEVERE, "[BC2] Unhandled exception trying to access a tank for display!\n", t);
        }
        return null;
    }

    public static String getLiquidName(int liquidId) {
        return LiquidHelper.getLiquidName(new LiquidSlot(liquidId, 1, 1));
    }

    public static String getLiquidName(Object liquidSlotRaw) {
        try {
            LiquidSlot liquidSlot = (LiquidSlot)liquidSlotRaw;
            ul stack = new ul(liquidSlot.getLiquidId(), 1, 0);
            return DisplayUtil.itemDisplayNameShort(stack);
        }
        catch (Throwable throwable) {
            return I18n.translate("hud.msg.unknown", new Object[0]);
        }
    }

    static {
        try {
            ILiquidContainer_getCapacity = AccessHelper.getMethod(ILiquidContainer.class, new Class[0], "getCapacity");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

