/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.ModIdentification;
import mcp.mobius.waila.utils.SpawnUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerBlocks
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBlocks();

    private HUDHandlerBlocks() {
    }

    @Override
    public ul getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            String s = DisplayUtil.itemDisplayNameShort(itemStack);
            String name = null;
            if (s != null && !s.endsWith("Unnamed")) {
                name = s;
            }
            if (name != null) {
                currenttip.add(name);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (currenttip.isEmpty()) {
            currenttip.add(I18n.translate("hud.msg.please_report", new Object[0]));
        }
        if (PluginConfig.instance().get("general", "waila.cfg.metadata", true)) {
            currenttip.add("\u00a7oID " + accessor.getBlockID() + ":" + accessor.getMetadata());
        }
    }

    @Override
    public void modifyBody(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        lr b = accessor.getBlock();
        int meta = accessor.getMetadata();
        rv w = accessor.getWorld();
        int x = accessor.getPosition().b;
        int y = accessor.getPosition().c;
        int z = accessor.getPosition().d;
        if (config.get("general.harvest")) {
            String harvest = "hud.msg.please_report";
            if (b != null) {
                harvest = mod_BlockHelper.Accessor.getHardness(b, meta) < 0.0f ? "hud.msg.unbreakable" : (mod_BlockHelper.Accessor.canHarvestBlock(b, accessor.getPlayer()) ? "hud.msg.harvestable" : "hud.msg.not_harvestable");
            }
            currenttip.add(I18n.translate(harvest, new Object[0]));
        }
        if (config.get("general.lightlevel") && (!w.h(x, y + 1, z) || w.i(x, y + 1, z))) {
            int blockLightLevel = w.b(rf.b, x, y + 1, z);
            byte spawnMode = SpawnUtil.getSpawnMode(w, x, y + 1, z);
            String blockLight = (spawnMode == 0 ? "\u00a7a" : (spawnMode == 1 ? "\u00a7e" : "\u00a74")) + blockLightLevel;
            String skyLight = w.b(rf.a, x, y + 1, z) + "";
            currenttip.add(I18n.translate("hud.msg.light_level", new Object[0]) + ": " + blockLight + "\u00a7e" + " (" + skyLight + ")");
        }
        if (config.get("general.break")) {
            try {
                float curBlockDamage = ModLoader.getMinecraftInstance().g.g;
                if (curBlockDamage > 0.0f) {
                    String progress = et.d((float)(100.0f * curBlockDamage)) + "%";
                    currenttip.add(I18n.translate("hud.msg.break_progression", new Object[0]) + ": " + progress);
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, "curBlockDamageMP", currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        String modName = ModIdentification.identifyMod(itemStack);
        if (modName.isEmpty()) {
            modName = ModIdentification.identifyMod(accessor.getTileEntity());
        }
        if (!modName.isEmpty()) {
            currenttip.add("\u00a79\u00a7o" + modName);
        }
    }

    @Override
    public void appendServerData(ij te, xb tag, IServerDataAccessor accessor, IPluginConfig config) {
        if (te != null) {
            te.b(tag);
        }
    }
}

