/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class HUDHandlerIC2IEnergyStorage
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerIC2IEnergyStorage();

    private HUDHandlerIC2IEnergyStorage() {
    }

    @Override
    public ul getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic2.storage")) {
            try {
                int storage = accessor.getNBTInteger("storage");
                int maxStorage = accessor.getNBTInteger("maxStorage");
                String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
                if (maxStorage > 0) {
                    currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " EU");
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ul itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(ij te, xb tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            int storage = -1;
            int maxStorage = -1;
            if (IC2Plugin.TileBaseGenerator.isInstance(te)) {
                storage = IC2Plugin.TileBaseGenerator_storage.getInt(te);
                maxStorage = IC2Plugin.TileBaseGenerator_maxStorage.getInt(te);
            }
            tag.a("storage", storage);
            tag.a("maxStorage", maxStorage);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

