/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.api.ITaggedList;

public class TipList<E, T>
extends ArrayList<E>
implements ITaggedList<E, T> {
    private static final long serialVersionUID = -8943581880240674902L;
    private final Map<E, Set<T>> tags = new HashMap<E, Set<T>>();

    @Override
    public boolean add(E e, T tag) {
        if (!this.tags.containsKey(e)) {
            this.tags.put(e, new HashSet());
        }
        this.tags.get(e).add(tag);
        return super.add(e);
    }

    @Override
    public boolean add(E e, Collection<? extends T> taglst) {
        if (!this.tags.containsKey(e)) {
            this.tags.put(e, new HashSet());
        }
        this.tags.get(e).addAll(taglst);
        return super.add(e);
    }

    @Override
    public Set<T> getTags(E e) {
        Set<T> ret = this.tags.get(e);
        if (ret == null && this.contains(e)) {
            this.tags.put(e, new HashSet());
            ret = this.tags.get(e);
        }
        return ret;
    }

    @Override
    public Set<T> getTags(int index) {
        return this.getTags(this.get(index));
    }

    @Override
    public void addTag(E e, T tag) {
        if (this.contains(e) && !this.tags.containsKey(e)) {
            this.tags.put(e, new HashSet());
        }
        this.tags.get(e).add(tag);
    }

    @Override
    public void addTag(int index, T tag) {
        this.addTag(this.get(index), tag);
    }

    @Override
    public void removeTag(E e, T tag) {
        if (this.contains(e) && !this.tags.containsKey(e)) {
            this.tags.put(e, new HashSet());
        }
        this.tags.get(e).remove(tag);
    }

    @Override
    public void removeTag(int index, T tag) {
        this.removeTag(this.get(index), tag);
    }

    @Override
    public Set<E> getEntries(T tag) {
        HashSet<E> ret = new HashSet<E>();
        for (Map.Entry<E, Set<T>> s : this.tags.entrySet()) {
            if (!s.getValue().contains(tag)) continue;
            ret.add(s.getKey());
        }
        return ret;
    }

    @Override
    public void removeEntries(T tag) {
        for (E e : this.getEntries(tag)) {
            this.remove(e);
        }
    }

    @Override
    public String getTagsAsString(E e) {
        StringBuilder ret = new StringBuilder();
        for (T s : this.tags.get(e)) {
            ret.append(s.toString()).append(",");
        }
        if (ret.length() > 0) {
            ret = new StringBuilder(ret.substring(0, ret.length() - 1));
        }
        return ret.toString();
    }

    @Override
    public void clear() {
        this.tags.clear();
        super.clear();
    }

    @Override
    public E set(int index, E element) {
        this.tags.remove(this.get(index));
        return super.set(index, element);
    }

    @Override
    public E remove(int index) {
        this.tags.remove(this.get(index));
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.tags.remove(o);
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.tags.remove(o);
        }
        return super.removeAll(c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            this.tags.remove(this.get(i2));
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (E e : this.tags.keySet()) {
            if (c.contains(e)) continue;
            this.tags.remove(e);
        }
        return super.retainAll(c);
    }
}

