/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.Dimension;

public final class DisplayUtil {
    private static final kh fontRenderer = ModLoader.getMinecraftInstance().q;
    private static final ur renderEngine = ModLoader.getMinecraftInstance().p;
    private static final pj renderItem = new pj();

    private DisplayUtil() {
        throw new UnsupportedOperationException();
    }

    public static int getDisplayWidth(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int width = 0;
        Matcher renderMatcher = SpecialChars.patternRender.matcher(s);
        while (renderMatcher.find()) {
            ITooltipRenderer renderer = WailaRegistrar.instance().getTooltipRenderer(renderMatcher.group(1));
            if (renderer == null) continue;
            width += renderer.getSize(renderMatcher.group(2).split(","), DataAccessorCommon.INSTANCE).getWidth();
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        return width += fontRenderer.a(DisplayUtil.stripSymbols(s));
    }

    public static Dimension displaySize() {
        Minecraft mc = ModLoader.getMinecraftInstance();
        za res = new za(mc.z, mc.d, mc.e);
        return new Dimension(res.a(), res.b());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ul stack) {
        if (stack == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ow.b();
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        GL13.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            renderItem.a(fontRenderer, renderEngine, stack, x, y);
            renderItem.b(fontRenderer, renderEngine, stack, x, y);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, stack.a().getClass(), null);
        }
        GL11.glDisable((int)32826);
        ow.a();
    }

    public static void drawGradientRect(int x, int y, int w, int h, int grad1, int grad2) {
        float zLevel = 0.0f;
        float f = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(grad1 & 0xFF) / 255.0f;
        float f4 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        xe tessellator = xe.a;
        tessellator.b();
        tessellator.a(f1, f2, f3, f);
        tessellator.a((double)(x + w), (double)y, (double)zLevel);
        tessellator.a((double)x, (double)y, (double)zLevel);
        tessellator.a(f5, f6, f7, f4);
        tessellator.a((double)x, (double)(y + h), (double)zLevel);
        tessellator.a((double)(x + w), (double)(y + h), (double)zLevel);
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int w, int h, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        xe tessellator = xe.a;
        tessellator.b();
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.a((double)x, (double)(y + h), (double)zLevel, (double)((float)u * f), (double)((float)(v + th) * f1));
        tessellator.a((double)(x + w), (double)(y + h), (double)zLevel, (double)((float)(u + tw) * f), (double)((float)(v + th) * f1));
        tessellator.a((double)(x + w), (double)y, (double)zLevel, (double)((float)(u + tw) * f), (double)((float)v * f1));
        tessellator.a((double)x, (double)y, (double)zLevel, (double)((float)u * f), (double)((float)v * f1));
        tessellator.a();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.a(text, x, y, colour);
        } else {
            fontRenderer.b(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultilineUnformatted(ul itemstack) {
        ArrayList<String> namelist = new ArrayList<String>();
        try {
            String name = I18n.translate(itemstack.l() + ".name", new Object[0]);
            if (name != null && !name.isEmpty()) {
                namelist.add(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist.isEmpty()) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).isEmpty()) {
            namelist.set(0, "Unnamed");
        }
        return namelist;
    }

    public static String itemDisplayNameShortUnformatted(ul itemstack) {
        return DisplayUtil.itemDisplayNameMultilineUnformatted(itemstack).get(0);
    }

    public static List<String> itemDisplayNameMultiline(ul itemstack) {
        List<String> namelist = DisplayUtil.itemDisplayNameMultilineUnformatted(itemstack);
        namelist.set(0, "\u00a7f" + namelist.get(0));
        for (int i2 = 1; i2 < namelist.size(); ++i2) {
            namelist.set(i2, "\u00a77" + namelist.get(i2));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ul itemstack) {
        return DisplayUtil.itemDisplayNameMultiline(itemstack).get(0);
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        if (icon == null) {
            return;
        }
        ModLoader.getMinecraftInstance().p.b(ModLoader.getMinecraftInstance().p.b(icon.texture));
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }
}

