/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.ICropProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.utils.I18n;

public class DefaultCropProvider
implements ICropProvider {
    protected final int minStage;
    protected final int maxStage;
    protected final Integer ripeStage;

    public DefaultCropProvider(int maxStage) {
        this(maxStage, null);
    }

    public DefaultCropProvider(int maxStage, Integer ripeStage) {
        this(0, maxStage, ripeStage);
    }

    public DefaultCropProvider(int minStage, int maxStage, Integer ripeStage) {
        this.minStage = minStage;
        this.maxStage = maxStage;
        this.ripeStage = ripeStage;
    }

    public boolean shouldHandle(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return true;
    }

    public int getCurrentStage(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return accessor.getMetadata() - this.minStage;
    }

    public int getMaxStage(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return this.maxStage - this.minStage;
    }

    public Integer getRipeStage(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return this.ripeStage == null ? null : Integer.valueOf(this.ripeStage - this.minStage);
    }

    public String getGrowthString(iw itemStack, IDataAccessor accessor, IPluginConfig config, float growthValue) {
        return String.format("%s: %.0f %%", I18n.translate("hud.msg.growth", new Object[0]), Float.valueOf(growthValue));
    }

    public String getMatureString(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return I18n.translate("hud.msg.growth", new Object[0]) + ": " + I18n.translate("hud.msg.mature", new Object[0]);
    }

    public String getRipeString(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        return I18n.translate("hud.msg.growth", new Object[0]) + ": " + I18n.translate("hud.msg.ripe", new Object[0]);
    }

    @Override
    public List<String> getGrowthDetails(iw itemStack, IDataAccessor accessor, IPluginConfig config) {
        ArrayList<String> ret = new ArrayList<String>();
        if (!this.shouldHandle(itemStack, accessor, config)) {
            return ret;
        }
        int currentStage = this.getCurrentStage(itemStack, accessor, config);
        Integer ripeStage = this.getRipeStage(itemStack, accessor, config);
        if (ripeStage != null && currentStage >= ripeStage) {
            ret.add(this.getRipeString(itemStack, accessor, config));
        } else {
            float growthValue = (float)currentStage / (float)this.getMaxStage(itemStack, accessor, config) * 100.0f;
            ret.add((double)growthValue < 100.0 ? this.getGrowthString(itemStack, accessor, config, growthValue) : this.getMatureString(itemStack, accessor, config));
        }
        return ret;
    }
}

