/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic;

import mcp.mobius.waila.addons.ic.ICPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class HUDHandlerMatterGen
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerMatterGen();

    private HUDHandlerMatterGen() {
    }

    @Override
    public iw getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(iw itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(iw itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic.mattergen")) {
            try {
                int matterGeneration = accessor.getNBTInteger("matterGeneration");
                int matterCost = accessor.getNBTInteger("matterCost");
                String progressStr = I18n.translate("hud.msg.progress", new Object[0]);
                if (matterCost > 0) {
                    int p = (int)(100.0f * (float)matterGeneration / (float)matterCost);
                    currenttip.add(progressStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(p, 100) + "%");
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(iw itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(os te, nq tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            int matterGeneration = -1;
            int matterCost = -1;
            if (ICPlugin.TileEntityMatterGen.isInstance(te)) {
                matterGeneration = ICPlugin.TileEntityMatterGen_matterGeneration.getInt(te);
                matterCost = ICPlugin.TileEntityMatterGen_matterCost.getInt(te);
            }
            tag.a("matterGeneration", matterGeneration);
            tag.a("matterCost", matterCost);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, te.getClass(), null);
        }
    }
}

