/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class HUDHandlerIC2IEnergySource
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerIC2IEnergySource();

    private HUDHandlerIC2IEnergySource() {
    }

    @Override
    public aai getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(aai itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(aai itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic2.outputeu")) {
            try {
                int out = accessor.getNBTInteger("maxOutput");
                String outputStr = I18n.translate("hud.msg.output", new Object[0]);
                if (out > 0) {
                    currenttip.add(outputStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + out + "\u00a7r" + " EU/t");
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(aai itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(kt te, adt tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            int out = -1;
            if (IC2Plugin.IEnergySource.isInstance(te)) {
                out = (Integer)IC2Plugin.IEnergySource_getOutput.invoke((Object)te, new Object[0]);
            }
            tag.a("maxOutput", out);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

