/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public fz getStack(IDataAccessor accessor, IPluginConfig config) {
        og block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.redstone) {
            return new fz(ee.aA);
        }
        if (block instanceof aq) {
            return new fz(og.aN);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new fz(ee.aH);
        }
        if (block == VanillaPlugin.crops) {
            return new fz(ee.R);
        }
        return null;
    }

    @Override
    public void modifyHead(fz itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        og block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof bn && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((bn)accessor.getTileEntity()).b;
            currenttip.set(0, name + " (" + mobname + ")");
        }
    }

    @Override
    public void modifyBody(fz itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        og block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            je tag = accessor.getNBTData();
            ee record = null;
            if (meta != 0) {
                record = ee.c[ee.aU.aW + meta - 1];
            }
            try {
                currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + VanillaPlugin.ItemRecord_recordName.get(record));
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, block.getClass().getName() + ":" + meta, currenttip);
            }
        }
    }

    @Override
    public void modifyTail(fz itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(jx te, je tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

