/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class AccessHelper {
    private AccessHelper() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> getClass(String clazz) throws ClassNotFoundException {
        try {
            return Class.forName(clazz);
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(clazz);
        }
    }

    public static Constructor<?> getDeclaredConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Throwable throwable) {
            throw new NoSuchMethodException(clazz.getName() + ".<init>(" + parameterTypes.length + " params)");
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Throwable throwable) {
            throw new NoSuchMethodException(clazz.getName() + ".<init>(" + parameterTypes.length + " params)");
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, Class<?>[] parameterTypes, String ... methodNames) throws NoSuchMethodException {
        for (String methodName : methodNames) {
            try {
                Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (Throwable ignored) {
            }
        }
        throw new NoSuchMethodException(clazz.getName() + "." + Arrays.toString(methodNames) + "(" + parameterTypes.length + " params)");
    }

    public static Method getMethod(Class<?> clazz, Class<?>[] parameterTypes, String ... methodNames) throws NoSuchMethodException {
        for (String methodName : methodNames) {
            try {
                Method m = clazz.getMethod(methodName, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (Throwable ignored) {
            }
        }
        throw new NoSuchMethodException(clazz.getName() + "." + Arrays.toString(methodNames) + "(" + parameterTypes.length + " params)");
    }

    public static Field getDeclaredField(Class<?> clazz, String ... fieldNames) throws NoSuchFieldException {
        for (String fieldName : fieldNames) {
            try {
                Field f2 = clazz.getDeclaredField(fieldName);
                f2.setAccessible(true);
                return f2;
            }
            catch (Throwable ignored) {
            }
        }
        throw new NoSuchFieldException(clazz.getName() + "." + Arrays.toString(fieldNames));
    }

    public static Field getField(Class<?> clazz, String ... fieldNames) throws NoSuchFieldException {
        for (String fieldName : fieldNames) {
            try {
                Field f2 = clazz.getField(fieldName);
                f2.setAccessible(true);
                return f2;
            }
            catch (Throwable ignored) {
            }
        }
        throw new NoSuchFieldException(clazz.getName() + "." + Arrays.toString(fieldNames));
    }
}

