/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.network.IWailaPacket;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraftforge.common.Property;

public class Packet0x00ServerPing
implements IWailaPacket {
    Map<String, Boolean> forcedKeys = new HashMap<String, Boolean>();

    public Packet0x00ServerPing() {
        Map serverForcingCfg = (Map)PluginConfig.instance().config.categories.get("server_forcing");
        for (String key : serverForcingCfg.keySet()) {
            if (!((Property)serverForcingCfg.get(key)).getBoolean(false)) continue;
            this.forcedKeys.put(key, PluginConfig.instance().get(key));
        }
    }

    @Override
    public void encode(DataOutputStream target) throws Exception {
        target.writeShort(this.forcedKeys.size());
        for (String key : this.forcedKeys.keySet()) {
            ef.a((String)key, (DataOutputStream)target);
            target.writeBoolean(this.forcedKeys.get(key));
        }
    }

    @Override
    public void decode(DataInputStream dat) {
        try {
            this.forcedKeys = new HashMap<String, Boolean>();
            int nkeys = dat.readShort();
            for (int i = 0; i < nkeys; ++i) {
                this.forcedKeys.put(ef.a((DataInputStream)dat, (int)255), dat.readBoolean());
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, this.getClass(), null);
        }
    }

    @Override
    public void handleClient() {
        mod_BlockHelper.LOG.info("Received server authentication packet. Remote sync is active: " + this.forcedKeys.toString());
        mod_BlockHelper.INSTANCE.serverPresent = true;
        PluginConfig.instance().forcedConfigs = this.forcedKeys;
    }

    @Override
    public void handleServer(Player rawSender) {
    }

    public static void resetClient() {
        mod_BlockHelper.INSTANCE.serverPresent = false;
        PluginConfig.instance().forcedConfigs = new HashMap<String, Boolean>();
    }
}

