/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.appeng;

import mcp.mobius.waila.addons.appeng.AppEngPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public final class HUDHandlerMEPowerStorage
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerMEPowerStorage();

    private HUDHandlerMEPowerStorage() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            int storage = accessor.getNBTInteger("AEStorage");
            int maxStorage = accessor.getNBTInteger("AEMaxStorage");
            String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
            if (config.get("appeng.storage") && maxStorage > 0) {
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " AE");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            float storage = -1.0f;
            float maxStorage = -1.0f;
            if (AppEngPlugin.IMEPowerStorage.isInstance(te)) {
                storage = (float)((Double)AppEngPlugin.IMEPowerStorage_currentPower.invoke((Object)te, new Object[0])).doubleValue();
                maxStorage = (float)((Double)AppEngPlugin.IMEPowerStorage_maxPower.invoke((Object)te, new Object[0])).doubleValue();
            }
            tag.setInteger("AEStorage", Math.round(storage));
            tag.setInteger("AEMaxStorage", Math.round(maxStorage));
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

