/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screens.config;

import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.gui.events.MouseEvent;
import mcp.mobius.waila.gui.interfaces.CType;
import mcp.mobius.waila.gui.interfaces.IWidget;
import mcp.mobius.waila.gui.interfaces.RenderPriority;
import mcp.mobius.waila.gui.interfaces.Signal;
import mcp.mobius.waila.gui.interfaces.WAlign;
import mcp.mobius.waila.gui.screens.ScreenBase;
import mcp.mobius.waila.gui.widgets.LabelFixedFont;
import mcp.mobius.waila.gui.widgets.LayoutBase;
import mcp.mobius.waila.gui.widgets.LayoutMargin;
import mcp.mobius.waila.gui.widgets.WidgetGeometry;
import mcp.mobius.waila.gui.widgets.buttons.ButtonLabel;
import mcp.mobius.waila.gui.widgets.buttons.ButtonScreenChange;
import mcp.mobius.waila.gui.widgets.movable.PictureMovableRC;
import mcp.mobius.waila.overlay.OverlayConfig;
import net.minecraft.client.gui.GuiScreen;

public class ScreenHUDConfig
extends ScreenBase {
    public ScreenHUDConfig(GuiScreen parent) {
        super(parent);
        this.getRoot().addWidget("EventCanvas", new EventCanvas(this.getRoot(), parent));
    }

    private static class EventCanvas
    extends LayoutBase {
        IWidget draggedWidget = null;
        float scale;

        public EventCanvas(IWidget parent, GuiScreen prevScreen) {
            super(parent);
            this.setGeometry(new WidgetGeometry(0.0, 0.0, 100.0, 100.0, CType.RELXY, CType.RELXY));
            double picX = (double)PluginConfig.instance().get("general", "waila.cfg.posx", 0) / 100.0;
            double picY = (double)PluginConfig.instance().get("general", "waila.cfg.posy", 0) / 100.0;
            float picAlpha = (float)PluginConfig.instance().get("general", "waila.cfg.alpha", 0) / 100.0f;
            this.scale = (float)PluginConfig.instance().get("general", "waila.cfg.scale", 0) / 100.0f;
            int picSX = (int)(180.0f / (float)this.rez.getScaleFactor() * this.scale);
            int picSY = (int)(62.0f / (float)this.rez.getScaleFactor() * this.scale);
            this.addWidget("Layout", new LayoutMargin(null), RenderPriority.HIGH);
            ((LayoutMargin)this.getWidget("Layout")).setMargins(picSX / 2, picSX / 2, picSY / 2, picSY / 2);
            this.getWidget("Layout").addWidget("Picture", new PictureMovableRC(null, "/assets/waila/textures/config_template.png")).setGeometry(new WidgetGeometry(picX, picY, picSX, picSY, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            this.addWidget("TextTuto1", new LabelFixedFont(null, "screen.label.dragtuto")).setGeometry(new WidgetGeometry(50.0, 30.0, 20.0, 20.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            IWidget layoutX = this.addWidget("LayoutX", new LayoutBase(this));
            layoutX.setGeometry(new WidgetGeometry(35.0, 50.0, 20.0, 80.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            layoutX.addWidget("LabelX", new LabelFixedFont(null, "X")).setGeometry(new WidgetGeometry(50.0, 0.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutX.addWidget("ButtonXAdd", new ButtonLabel(null, "+")).setGeometry(new WidgetGeometry(0.0, 10.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            layoutX.addWidget("ValueDisplayX", new LabelFixedFont(null, "0")).setGeometry(new WidgetGeometry(50.0, 40.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutX.addWidget("ButtonXSub", new ButtonLabel(null, "-")).setGeometry(new WidgetGeometry(0.0, 60.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            IWidget layoutY = this.addWidget("LayoutY", new LayoutBase(this));
            layoutY.setGeometry(new WidgetGeometry(45.0, 50.0, 20.0, 80.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            layoutY.addWidget("LabelY", new LabelFixedFont(null, "Y")).setGeometry(new WidgetGeometry(50.0, 0.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutY.addWidget("ButtonYAdd", new ButtonLabel(null, "+")).setGeometry(new WidgetGeometry(0.0, 10.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            layoutY.addWidget("ValueDisplayY", new LabelFixedFont(null, "0")).setGeometry(new WidgetGeometry(50.0, 40.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutY.addWidget("ButtonYSub", new ButtonLabel(null, "-")).setGeometry(new WidgetGeometry(0.0, 60.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            IWidget layoutAlpha = this.addWidget("LayoutAlpha", new LayoutBase(this));
            layoutAlpha.setGeometry(new WidgetGeometry(55.0, 50.0, 20.0, 80.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            layoutAlpha.addWidget("LabelAlpha", new LabelFixedFont(null, "Alpha")).setGeometry(new WidgetGeometry(50.0, 0.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutAlpha.addWidget("ButtonAlphaAdd", new ButtonLabel(null, "+")).setGeometry(new WidgetGeometry(0.0, 10.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            layoutAlpha.addWidget("ValueDisplayAlpha", new LabelFixedFont(null, "0")).setGeometry(new WidgetGeometry(50.0, 40.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutAlpha.addWidget("ButtonAlphaSub", new ButtonLabel(null, "-")).setGeometry(new WidgetGeometry(0.0, 60.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            IWidget layoutScale = this.addWidget("LayoutScale", new LayoutBase(this));
            layoutScale.setGeometry(new WidgetGeometry(65.0, 50.0, 20.0, 80.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
            layoutScale.addWidget("LabelScale", new LabelFixedFont(null, "screen.label.scale")).setGeometry(new WidgetGeometry(50.0, 0.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutScale.addWidget("ButtonScaleAdd", new ButtonLabel(null, "+")).setGeometry(new WidgetGeometry(0.0, 10.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            layoutScale.addWidget("ValueDisplayScale", new LabelFixedFont(null, "0")).setGeometry(new WidgetGeometry(50.0, 40.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.CENTER, WAlign.TOP));
            layoutScale.addWidget("ButtonScaleSub", new ButtonLabel(null, "-")).setGeometry(new WidgetGeometry(0.0, 60.0, 20.0, 20.0, CType.REL_X, CType.ABSXY, WAlign.LEFT, WAlign.TOP));
            this.addWidget("ButtonCancel", new ButtonScreenChange(null, "screen.button.cancel", prevScreen)).setGeometry(new WidgetGeometry(70.0, 97.0, 75.0, 20.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.BOTTOM));
            this.addWidget("ButtonOk", new ButtonScreenChange(null, "screen.button.ok", prevScreen)).setGeometry(new WidgetGeometry(30.0, 97.0, 75.0, 20.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.BOTTOM));
            this.addWidget("ButtonDefault", new ButtonLabel(null, "screen.button.default")).setGeometry(new WidgetGeometry(50.0, 97.0, 75.0, 20.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.BOTTOM));
            ((LabelFixedFont)this.getWidget("LayoutX").getWidget("ValueDisplayX")).setText(String.format("%.2f", picX));
            ((LabelFixedFont)this.getWidget("LayoutY").getWidget("ValueDisplayY")).setText(String.format("%.2f", picY));
            ((LabelFixedFont)this.getWidget("LayoutAlpha").getWidget("ValueDisplayAlpha")).setText(String.format("%.2f", Float.valueOf(picAlpha)));
            ((LabelFixedFont)this.getWidget("LayoutScale").getWidget("ValueDisplayScale")).setText(String.format("%.2f", Float.valueOf(this.scale)));
            this.getWidget("Layout").getWidget("Picture").setAlpha(picAlpha);
        }

        @Override
        public IWidget getWidgetAtCoordinates(double posX, double posY) {
            if (this.getWidget("Layout").getWidget("Picture").isWidgetAtCoordinates(posX, posY)) {
                return this.getWidget("Layout").getWidget("Picture");
            }
            return super.getWidgetAtCoordinates(posX, posY);
        }

        @Override
        public void onMouseClick(MouseEvent event) {
            if (event.button == 0 && this.getWidget("Layout").getWidget("Picture").isWidgetAtCoordinates(event.x, event.y)) {
                this.getWidget("Layout").getWidget("Picture").onMouseClick(event);
                this.draggedWidget = this.getWidget("Layout").getWidget("Picture");
            } else {
                super.onMouseClick(event);
            }
        }

        @Override
        public void onMouseDrag(MouseEvent event) {
            if (this.draggedWidget != null) {
                this.draggedWidget.onMouseDrag(event);
            } else {
                super.onMouseDrag(event);
            }
        }

        @Override
        public void onMouseRelease(MouseEvent event) {
            if (event.button == 0) {
                this.draggedWidget = null;
            }
            super.onMouseRelease(event);
        }

        private void updateData() {
            ((LabelFixedFont)this.getWidget("LayoutX").getWidget("ValueDisplayX")).setText(String.format("%.2f", this.getWidget("Layout").getWidget("Picture").getGeometry().getRawPos().getX()));
            ((LabelFixedFont)this.getWidget("LayoutY").getWidget("ValueDisplayY")).setText(String.format("%.2f", this.getWidget("Layout").getWidget("Picture").getGeometry().getRawPos().getY()));
            ((LabelFixedFont)this.getWidget("LayoutAlpha").getWidget("ValueDisplayAlpha")).setText(String.format("%.2f", Float.valueOf(this.getWidget("Layout").getWidget("Picture").getAlpha())));
            ((LabelFixedFont)this.getWidget("LayoutScale").getWidget("ValueDisplayScale")).setText(String.format("%.2f", Float.valueOf(this.scale)));
        }

        @Override
        public void onWidgetEvent(IWidget srcwidget, Signal signal, Object ... params) {
            if (this.getWidget("Layout") == null) {
                return;
            }
            if (srcwidget.equals(this.getWidget("Layout").getWidget("Picture")) && signal == Signal.DRAGGED) {
                this.draggedWidget = this.getWidget("Layout").getWidget("Picture");
                this.updateData();
            }
            if (signal == Signal.CLICKED) {
                int picSY;
                double newPos;
                IWidget picture = this.getWidget("Layout").getWidget("Picture");
                double pictureX = picture.getGeometry().getRawPos().getX();
                double pictureY = picture.getGeometry().getRawPos().getY();
                double pixelToPercentX = 100.0 / (double)picture.getParent().getSize().getX();
                double pixelToPercentY = 100.0 / (double)picture.getParent().getSize().getY();
                if (srcwidget.equals(this.getWidget("LayoutX").getWidget("ButtonXAdd"))) {
                    newPos = Math.min(pictureX + pixelToPercentX, 100.0);
                    picture.setPos(newPos, pictureY);
                }
                if (srcwidget.equals(this.getWidget("LayoutX").getWidget("ButtonXSub"))) {
                    newPos = Math.max(pictureX - pixelToPercentX, 0.0);
                    picture.setPos(newPos, pictureY);
                }
                if (srcwidget.equals(this.getWidget("LayoutY").getWidget("ButtonYAdd"))) {
                    newPos = Math.min(pictureY + pixelToPercentY, 100.0);
                    picture.setPos(pictureX, newPos);
                }
                if (srcwidget.equals(this.getWidget("LayoutY").getWidget("ButtonYSub"))) {
                    newPos = Math.max(pictureY - pixelToPercentY, 0.0);
                    picture.setPos(pictureX, newPos);
                }
                if (srcwidget.equals(this.getWidget("LayoutAlpha").getWidget("ButtonAlphaAdd"))) {
                    picture.setAlpha(Math.min(picture.getAlpha() + 0.05f, 1.0f));
                }
                if (srcwidget.equals(this.getWidget("LayoutAlpha").getWidget("ButtonAlphaSub"))) {
                    picture.setAlpha(Math.max(picture.getAlpha() - 0.05f, 0.0f));
                }
                if (srcwidget.equals(this.getWidget("LayoutScale").getWidget("ButtonScaleAdd"))) {
                    this.scale += 0.05f;
                    this.scale = Math.max(0.1f, this.scale);
                    this.scale = Math.min(2.0f, this.scale);
                    int picSX = (int)(180.0f / (float)this.rez.getScaleFactor() * this.scale);
                    picSY = (int)(62.0f / (float)this.rez.getScaleFactor() * this.scale);
                    picture.setSize(picSX, picSY);
                    ((LayoutMargin)this.getWidget("Layout")).setMargins(picSX / 2, picSX / 2, picSY / 2, picSY / 2);
                }
                if (srcwidget.equals(this.getWidget("LayoutScale").getWidget("ButtonScaleSub"))) {
                    this.scale -= 0.05f;
                    this.scale = Math.max(0.1f, this.scale);
                    this.scale = Math.min(2.0f, this.scale);
                    int picSX = (int)(180.0f / (float)this.rez.getScaleFactor() * this.scale);
                    picSY = (int)(62.0f / (float)this.rez.getScaleFactor() * this.scale);
                    picture.setSize(picSX, picSY);
                    ((LayoutMargin)this.getWidget("Layout")).setMargins(picSX / 2, picSX / 2, picSY / 2, picSY / 2);
                }
                this.updateData();
            }
            if (srcwidget.equals(this.getWidget("ButtonOk")) && signal == Signal.CLICKED) {
                PluginConfig.instance().setConfig("general", "waila.cfg.posx", (int)(this.getWidget("Layout").getWidget("Picture").getGeometry().getRawPos().getX() * 100.0));
                PluginConfig.instance().setConfig("general", "waila.cfg.posy", (int)(this.getWidget("Layout").getWidget("Picture").getGeometry().getRawPos().getY() * 100.0));
                PluginConfig.instance().setConfig("general", "waila.cfg.alpha", (int)((double)this.getWidget("Layout").getWidget("Picture").getAlpha() * 100.0));
                PluginConfig.instance().setConfig("general", "waila.cfg.scale", (int)((double)this.scale * 100.0));
                OverlayConfig.alpha = PluginConfig.instance().get("general", "waila.cfg.alpha", 0);
                OverlayConfig.posX = PluginConfig.instance().get("general", "waila.cfg.posx", 0);
                OverlayConfig.posY = PluginConfig.instance().get("general", "waila.cfg.posy", 0);
                OverlayConfig.scale = (float)PluginConfig.instance().get("general", "waila.cfg.scale", 0) / 100.0f;
                OverlayConfig.updateColors();
            }
            if (srcwidget.equals(this.getWidget("ButtonDefault")) && signal == Signal.CLICKED) {
                this.getWidget("Layout").getWidget("Picture").setPos(50.0, 1.0);
                this.getWidget("Layout").getWidget("Picture").setAlpha(0.8f);
                this.scale = 1.0f;
                int picSX = (int)(180.0f / (float)this.rez.getScaleFactor() * this.scale);
                int picSY = (int)(62.0f / (float)this.rez.getScaleFactor() * this.scale);
                this.getWidget("Layout").getWidget("Picture").setSize(picSX, picSY);
                ((LayoutMargin)this.getWidget("Layout")).setMargins(picSX / 2, picSX / 2, picSY / 2, picSY / 2);
                this.updateData();
            }
        }
    }
}

