/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcp.mobius.waila.api.IBlockDecorator;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class DecoratorRenderer {
    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (RayTracing.instance().getTarget() == null || RayTracing.instance().getTargetStack() == null) {
            return;
        }
        double partialTicks = event.partialTicks;
        DataAccessorCommon accessor = DataAccessorCommon.INSTANCE;
        WorldClient world = Minecraft.getMinecraft().theWorld;
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        EntityLiving viewEntity = Minecraft.getMinecraft().renderViewEntity;
        if (world == null || player == null || viewEntity == null) {
            return;
        }
        accessor.set((World)world, (EntityPlayer)player, RayTracing.instance().getTarget(), viewEntity, partialTicks);
        Block block = accessor.getBlock();
        if (!WailaRegistrar.instance().hasBlockDecorator(block)) {
            return;
        }
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        if (WailaRegistrar.instance().hasBlockDecorator(block)) {
            for (List<IBlockDecorator> decoratorsList : WailaRegistrar.instance().getBlockDecorators(block).values()) {
                for (IBlockDecorator decorator : decoratorsList) {
                    GL11.glPushMatrix();
                    try {
                        decorator.decorateBlock(RayTracing.instance().getTargetStack(), accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, decorator.getClass(), null);
                    }
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glEnable((int)3553);
        GL11.glPopAttrib();
    }
}

