/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.proxy;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.addons.advmachines.AdvMachinesPlugin;
import mcp.mobius.waila.addons.advsolars.AdvSolarsPlugin;
import mcp.mobius.waila.addons.appeng.AppEngPlugin;
import mcp.mobius.waila.addons.barrels.BarrelsPlugin;
import mcp.mobius.waila.addons.bc3.BC3Plugin;
import mcp.mobius.waila.addons.cc.ChickenChunksPlugin;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.addons.ee2.EE2Plugin;
import mcp.mobius.waila.addons.ee3.EE3Plugin;
import mcp.mobius.waila.addons.enderstorage.EnderStoragePlugin;
import mcp.mobius.waila.addons.fmp.FMPPlugin;
import mcp.mobius.waila.addons.forge.ForgePlugin;
import mcp.mobius.waila.addons.harvestcraft.HarvestcraftPlugin;
import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.addons.meteors.MeteorsPlugin;
import mcp.mobius.waila.addons.natura.NaturaPlugin;
import mcp.mobius.waila.addons.projectzulu.ProjectZuluPlugin;
import mcp.mobius.waila.addons.railcraft.RailcraftPlugin;
import mcp.mobius.waila.addons.thaumcraft.ThaumcraftPlugin;
import mcp.mobius.waila.addons.thermalexpansion.ThermalExpansionPlugin;
import mcp.mobius.waila.addons.totalpanels.TotalPanelsPlugin;
import mcp.mobius.waila.addons.twilightforest.TwilightForestPlugin;
import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.event.WailaRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class ProxyCommon {
    private final Side side;
    private final List<IWailaPlugin> corePlugins = new ArrayList<IWailaPlugin>();
    private final List<IWailaPlugin> plugins = new ArrayList<IWailaPlugin>();

    public ProxyCommon(Side side) {
        this.side = side;
    }

    private void registerCorePlugin(IWailaPlugin plugin) {
        this.corePlugins.add(plugin);
    }

    public void registerPlugin(IWailaPlugin plugin) {
        this.plugins.add(plugin);
    }

    public void prepare() {
        this.registerCorePlugin(CorePlugin.INSTANCE);
        this.registerCorePlugin(FMPPlugin.INSTANCE);
        this.registerCorePlugin(VanillaPlugin.INSTANCE);
        this.registerPlugin(AdvMachinesPlugin.INSTANCE);
        this.registerPlugin(AdvSolarsPlugin.INSTANCE);
        this.registerPlugin(AppEngPlugin.INSTANCE);
        this.registerPlugin(BarrelsPlugin.INSTANCE);
        this.registerPlugin(BC3Plugin.INSTANCE);
        this.registerPlugin(ChickenChunksPlugin.INSTANCE);
        this.registerPlugin(EE2Plugin.INSTANCE);
        this.registerPlugin(EE3Plugin.INSTANCE);
        this.registerPlugin(EnderStoragePlugin.INSTANCE);
        this.registerPlugin(HarvestcraftPlugin.INSTANCE);
        this.registerPlugin(IC2Plugin.INSTANCE);
        this.registerPlugin(MeteorsPlugin.INSTANCE);
        this.registerPlugin(NaturaPlugin.INSTANCE);
        this.registerPlugin(ProjectZuluPlugin.INSTANCE);
        this.registerPlugin(RailcraftPlugin.INSTANCE);
        this.registerPlugin(ThaumcraftPlugin.INSTANCE);
        this.registerPlugin(ThermalExpansionPlugin.INSTANCE);
        this.registerPlugin(TotalPanelsPlugin.INSTANCE);
        this.registerPlugin(TwilightForestPlugin.INSTANCE);
        this.registerPlugin(ForgePlugin.INSTANCE);
    }

    public void registerCorePlugins(IRegistrar registrar) {
        for (IWailaPlugin plugin : this.corePlugins) {
            this.registerPluginInRegistrar(registrar, plugin);
        }
    }

    public void registerModPlugins(IRegistrar registrar) {
        for (IWailaPlugin plugin : this.plugins) {
            this.registerPluginInRegistrar(registrar, plugin);
        }
    }

    private void registerPluginInRegistrar(IRegistrar registrar, IWailaPlugin plugin) {
        if (plugin.shouldRegister() && !MinecraftForge.EVENT_BUS.post((Event)new WailaRegisterEvent.Plugin(plugin))) {
            plugin.register(registrar, this.side);
        }
    }

    public void postLoad() {
    }
}

