/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mcp.mobius.waila.mod_BlockHelper;
import mcp.mobius.waila.utils.I18n;
import net.minecraft.client.Minecraft;

public class BlockHelperUpdater
implements Runnable {
    private static final String JSON_URL = "https://raw.githubusercontent.com/ThexXTURBOXx/UpdateJSONs/master/block-helper.csv";
    public boolean notify = false;
    private Status status = Status.NOT_STARTED;
    private String latestVersion = "";

    @Override
    public void run() {
        try {
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            List<String> latestVersions = this.getLatestModVersions(new URL(JSON_URL).openStream());
            if (latestVersions.isEmpty()) {
                throw new IllegalStateException("Version not found.");
            }
            this.latestVersion = latestVersions.get(0);
            Status status = this.status = latestVersions.contains("2.0.0-pre6") ? Status.UP_TO_DATE : Status.OUTDATED;
            if (this.status == Status.UP_TO_DATE) {
                mod_BlockHelper.LOG.info(I18n.translate("waila.newest_version_installed", "Block Helper"));
            } else {
                mod_BlockHelper.LOG.info(I18n.translate("waila.newer_version_available", "Block Helper", this.latestVersion));
            }
        }
        catch (Throwable t) {
            this.status = Status.ERRORED;
            mod_BlockHelper.LOG.log(Level.WARNING, I18n.translate("waila.update_check_failed", "Block Helper"), t);
        }
    }

    public String getLatestVersion() {
        if (this.latestVersion.isEmpty()) {
            this.latestVersion = "2.0.0-pre6";
        }
        return this.latestVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLatestModVersions(InputStream is) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split(",");
                if (!"1.5.2".equals(split[0])) continue;
                versions.add(split[1]);
            }
        }
        finally {
            is.close();
            isr.close();
            br.close();
        }
        return versions;
    }

    public void notifyUpdater(Minecraft mc) {
        if (!this.notify) {
            return;
        }
        if (this.status == Status.ERRORED) {
            mc.thePlayer.addChatMessage(I18n.translate("waila.update_check_failed_chat", "Block Helper"));
        } else if (this.status == Status.OUTDATED) {
            mc.thePlayer.addChatMessage(I18n.translate("waila.newer_version_available_chat", "Block Helper", "2.0.0-pre6", this.getLatestVersion()));
        }
    }

    public static enum Status {
        NOT_STARTED,
        ERRORED,
        OUTDATED,
        UP_TO_DATE;

    }
}

