/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fixerlink.compatapi.api.CompatLog;
import net.fixerlink.compatapi.api.Discovery;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class CodeLoader {
    private static final String[] HOOKS = new String[]{"register", "bootstrap", "init"};
    private static final Set<String> LOADED = ConcurrentHashMap.newKeySet();

    public static void loadAll() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        for (Map.Entry<String, Map<String, List<String>>> ownerEntry : Discovery.CODE_INDEX.entrySet()) {
            String owner = ownerEntry.getKey();
            Map<String, List<String>> byMod = ownerEntry.getValue();
            for (Map.Entry<String, List<String>> e : byMod.entrySet()) {
                String modid = e.getKey();
                if (!ModList.get().isLoaded(modid)) continue;
                for (String fqcn : e.getValue()) {
                    if (!LOADED.add(fqcn)) continue;
                    try {
                        Class<?> cls = Class.forName(fqcn);
                        Method m = CodeLoader.findHook(cls);
                        if (m == null) continue;
                        m.setAccessible(true);
                        m.invoke(null, modBus);
                    }
                    catch (Throwable t) {
                        CompatLog.error("[compatapi] fail " + fqcn, t);
                    }
                }
            }
        }
    }

    private static Method findHook(Class<?> cls) {
        for (String n : HOOKS) {
            try {
                return cls.getDeclaredMethod(n, IEventBus.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }
}

