/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fixerlink.compatapi.api.Discovery;
import net.fixerlink.compatapi.api.SubtreeDataPackResources;
import net.fixerlink.compatapi.compatapi;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compatapi", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataPacks {
    @SubscribeEvent
    public static void addPacks(AddPackFindersEvent e) {
        if (e.getPackType() != PackType.SERVER_DATA) {
            return;
        }
        for (Map.Entry<String, Map<String, List<Path>>> ownerEntry : Discovery.DATA_INDEX.entrySet()) {
            String owner = ownerEntry.getKey();
            Map<String, List<Path>> byMod = ownerEntry.getValue();
            for (Map.Entry<String, List<Path>> modEntry : byMod.entrySet()) {
                ForgeConfigSpec.BooleanValue toggle;
                String targetModid = modEntry.getKey();
                if (!ModList.get().isLoaded(targetModid) || (toggle = (ForgeConfigSpec.BooleanValue)compatapi.TOGGLES.getOrDefault(owner, Map.of()).get(targetModid)) == null || !((Boolean)toggle.get()).booleanValue()) continue;
                for (Path subtree : modEntry.getValue()) {
                    String packId = "compatapi:" + owner + ":" + targetModid + ":" + subtree.hashCode();
                    Pack.ResourcesSupplier supplier = id -> new SubtreeDataPackResources(id, owner, targetModid, subtree);
                    Pack pack = Pack.m_245429_((String)packId, (Component)Component.m_237113_((String)("Compat data: " + owner + " -> " + targetModid)), (boolean)false, (Pack.ResourcesSupplier)supplier, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    e.addRepositorySource(c -> c.accept(pack));
                }
            }
        }
    }
}

