/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;

public final class Discovery {
    public static final Map<String, Map<String, List<String>>> CODE_INDEX = new LinkedHashMap<String, Map<String, List<String>>>();
    public static final Map<String, Map<String, List<Path>>> DATA_INDEX = new LinkedHashMap<String, Map<String, List<Path>>>();
    public static final Set<String> OWNERS = new LinkedHashSet<String>();

    public static void scanAll() {
        CODE_INDEX.clear();
        DATA_INDEX.clear();
        OWNERS.clear();
        for (IModFileInfo info : ModList.get().getModFiles()) {
            if (!Discovery.usesCompatApi(info)) continue;
            Discovery.scanRoot(info.getFile());
        }
        OWNERS.addAll(CODE_INDEX.keySet());
        OWNERS.addAll(DATA_INDEX.keySet());
    }

    private static boolean usesCompatApi(IModFileInfo info) {
        for (IModInfo modInfo : info.getMods()) {
            if (!modInfo.getDependencies().stream().anyMatch(dep -> "compatapi".equals(dep.getModId()))) continue;
            return true;
        }
        return false;
    }

    private static void scanRoot(IModFile mf) {
        Path dataRoot;
        Path netRoot = mf.findResource(new String[]{"net"});
        if (netRoot != null && Files.isDirectory(netRoot, new LinkOption[0])) {
            try (Stream<Path> s2 = Files.walk(netRoot, new FileVisitOption[0]);){
                s2.filter(p -> p.toString().replace('\\', '/').contains("/compats/") && p.toString().endsWith(".class")).forEach(Discovery::indexClassFile);
            }
            catch (IOException s2) {
                // empty catch block
            }
        }
        if ((dataRoot = mf.findResource(new String[]{"data"})) != null && Files.isDirectory(dataRoot, new LinkOption[0])) {
            try (Stream<Path> owners = Files.list(dataRoot);){
                owners.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(ownerPath -> {
                    String owner = ownerPath.getFileName().toString();
                    Path compats = ownerPath.resolve("compats");
                    if (!Files.isDirectory(compats, new LinkOption[0])) {
                        return;
                    }
                    try (Stream<Path> targets = Files.list(compats);){
                        targets.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(targetDir -> {
                            String modid = targetDir.getFileName().toString();
                            DATA_INDEX.computeIfAbsent(owner, k -> new LinkedHashMap()).computeIfAbsent(modid, k -> new ArrayList()).add(targetDir);
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void indexClassFile(Path p) {
        int i;
        String norm = p.toString().replace('\\', '/');
        String[] segs = norm.split("/");
        int compatsIdx = -1;
        int netIdx = -1;
        for (i = 0; i < segs.length; ++i) {
            if (!segs[i].equals("compats")) continue;
            compatsIdx = i;
            break;
        }
        for (i = 0; i < segs.length; ++i) {
            if (!segs[i].equals("net")) continue;
            netIdx = i;
            break;
        }
        if (compatsIdx < 2 || compatsIdx + 1 >= segs.length || netIdx < 0) {
            return;
        }
        String owner = segs[compatsIdx - 1];
        String modid = segs[compatsIdx + 1];
        String className = String.join((CharSequence)".", Arrays.copyOfRange(segs, netIdx, segs.length)).replace(".class", "");
        CODE_INDEX.computeIfAbsent(owner, k -> new LinkedHashMap()).computeIfAbsent(modid, k -> new ArrayList()).add(className);
    }

    public static Set<String> getAllTargetsForOwner(String owner) {
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        out.addAll(CODE_INDEX.getOrDefault(owner, Map.of()).keySet());
        out.addAll(DATA_INDEX.getOrDefault(owner, Map.of()).keySet());
        return out;
    }
}

