/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;

class SubtreeDataPackResources
extends AbstractPackResources {
    private static final byte[] PACK_META = "{\"pack\":{\"pack_format\":15,\"description\":\"Compat API\"}}".getBytes(StandardCharsets.UTF_8);
    private final Path root;
    private final String owner;
    private final String target;
    private final List<String> glmIds;

    protected SubtreeDataPackResources(String id, String owner, String target, Path root) {
        super(id, true);
        this.root = root;
        this.owner = owner;
        this.target = target;
        this.glmIds = SubtreeDataPackResources.scanGlmIds(root, owner);
    }

    public IoSupplier<InputStream> m_8017_(String ... path) {
        if (path.length == 1 && "pack.mcmeta".equals(path[0])) {
            return () -> new ByteArrayInputStream(PACK_META);
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation rl) {
        if (type != PackType.SERVER_DATA) {
            return null;
        }
        if ("forge".equals(rl.m_135827_()) && "loot_modifiers/global_loot_modifiers.json".equals(rl.m_135815_()) && !this.glmIds.isEmpty()) {
            return () -> new ByteArrayInputStream(SubtreeDataPackResources.buildGlobalListBytes(this.glmIds));
        }
        if (!this.owner.equals(rl.m_135827_())) {
            return null;
        }
        Path p = this.root.resolve(rl.m_135815_()).normalize();
        if (!p.startsWith(this.root) || !Files.isRegularFile(p, new LinkOption[0])) {
            return null;
        }
        if (SubtreeDataPackResources.isLootModifierPath(rl.m_135815_())) {
            return () -> new ByteArrayInputStream(this.decorateLootModifier(p));
        }
        return () -> Files.newInputStream(p, new OpenOption[0]);
    }

    public void m_8031_(PackType type, String ns, String path, PackResources.ResourceOutput out) {
        if (type != PackType.SERVER_DATA) {
            return;
        }
        if ("forge".equals(ns) && "loot_modifiers".equals(path) && !this.glmIds.isEmpty()) {
            ResourceLocation id = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
            out.accept((Object)id, () -> new ByteArrayInputStream(SubtreeDataPackResources.buildGlobalListBytes(this.glmIds)));
            return;
        }
        if (!this.owner.equals(ns)) {
            return;
        }
        Path base = this.root.resolve(path).normalize();
        if (!base.startsWith(this.root) || !Files.exists(base, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> s = Files.walk(base, new FileVisitOption[0]);){
            s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                String rel = this.root.relativize((Path)p).toString().replace('\\', '/');
                ResourceLocation id = new ResourceLocation(this.owner, rel);
                if (SubtreeDataPackResources.isLootModifierPath(rel)) {
                    out.accept((Object)id, () -> new ByteArrayInputStream(this.decorateLootModifier((Path)p)));
                } else {
                    out.accept((Object)id, () -> Files.newInputStream(p, new OpenOption[0]));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<String> m_5698_(PackType type) {
        if (type != PackType.SERVER_DATA) {
            return Set.of();
        }
        return this.glmIds.isEmpty() ? Set.of(this.owner) : Set.of(this.owner, "forge");
    }

    public void close() {
    }

    private static boolean isLootModifierPath(String rel) {
        return rel.startsWith("loot_modifiers/") && rel.endsWith(".json");
    }

    private byte[] decorateLootModifier(Path file) {
        try {
            String src = Files.readString(file, StandardCharsets.UTF_8);
            JsonObject obj = JsonParser.parseString((String)src).getAsJsonObject();
            JsonObject compat = new JsonObject();
            compat.addProperty("condition", "compatapi:compat_enabled");
            compat.addProperty("owner", this.owner);
            compat.addProperty("target", this.target);
            if (obj.has("conditions")) {
                JsonElement ce = obj.get("conditions");
                if (ce.isJsonArray()) {
                    ce.getAsJsonArray().add((JsonElement)compat);
                } else {
                    JsonArray arr = new JsonArray();
                    arr.add(ce);
                    arr.add((JsonElement)compat);
                    obj.add("conditions", (JsonElement)arr);
                }
            } else {
                JsonArray arr = new JsonArray();
                arr.add((JsonElement)compat);
                obj.add("conditions", (JsonElement)arr);
            }
            return new Gson().toJson((JsonElement)obj).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            try {
                return Files.readAllBytes(file);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
    }

    private static List<String> scanGlmIds(Path root, String ownerNs) {
        Path glmRoot = root.resolve("loot_modifiers");
        if (!Files.isDirectory(glmRoot, new LinkOption[0])) {
            return List.of();
        }
        ArrayList<String> out = new ArrayList<String>();
        try (Stream<Path> s = Files.walk(glmRoot, new FileVisitOption[0]);){
            s.filter(p -> p.toString().endsWith(".json")).forEach(p -> {
                String rel = glmRoot.relativize((Path)p).toString().replace('\\', '/');
                if (rel.endsWith(".json")) {
                    rel = rel.substring(0, rel.length() - 5);
                }
                out.add(ownerNs + ":" + rel);
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    private static byte[] buildGlobalListBytes(List<String> entries) {
        JsonObject root = new JsonObject();
        root.addProperty("replace", Boolean.valueOf(false));
        JsonArray arr = new JsonArray();
        new LinkedHashSet<String>(entries).forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        root.add("entries", (JsonElement)arr);
        return new Gson().toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8);
    }
}

