/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSimpleItemModifier
extends LootModifier {
    public static final Codec<AddSimpleItemModifier> CODEC = RecordCodecBuilder.create(inst -> AddSimpleItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(m -> m.itemId), (App)Codec.INT.fieldOf("min").forGetter(m -> m.min), (App)Codec.INT.fieldOf("max").forGetter(m -> m.max), (App)Codec.INT.fieldOf("looting_bonus_max").forGetter(m -> m.lootingBonusMax), (App)ResourceLocation.f_135803_.optionalFieldOf("target_entity").forGetter(m -> Optional.ofNullable(m.targetEntityId)))).apply((Applicative)inst, (conds, item, min, max, lootMax, targetOpt) -> new AddSimpleItemModifier((LootItemCondition[])conds, (ResourceLocation)item, (int)min, (int)max, (int)lootMax, targetOpt.orElse(null))));
    private final ResourceLocation itemId;
    private final int min;
    private final int max;
    private final int lootingBonusMax;
    @Nullable
    private final ResourceLocation targetEntityId;

    public AddSimpleItemModifier(LootItemCondition[] conditions, ResourceLocation itemId, int min, int max, int lootingBonusMax, @Nullable ResourceLocation targetEntityId) {
        super(conditions);
        this.itemId = itemId;
        this.min = min;
        this.max = max;
        this.lootingBonusMax = lootingBonusMax;
        this.targetEntityId = targetEntityId;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext ctx) {
        Optional optItem;
        if (this.targetEntityId != null) {
            Entity ent = (Entity)ctx.m_78953_(LootContextParams.f_81455_);
            if (ent == null) {
                return generatedLoot;
            }
            ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)ent.m_6095_());
            if (!this.targetEntityId.equals((Object)key)) {
                return generatedLoot;
            }
        }
        if ((optItem = BuiltInRegistries.f_257033_.m_6612_(this.itemId)).isEmpty()) {
            return generatedLoot;
        }
        Item item = (Item)optItem.get();
        RandomSource rnd = ctx.m_230907_();
        int base = this.min == this.max ? this.min : rnd.m_188503_(this.max - this.min + 1) + this.min;
        int looting = Math.max(0, ctx.getLootingModifier());
        int bonus = this.lootingBonusMax > 0 ? rnd.m_188503_(this.lootingBonusMax + 1) * looting : 0;
        int count = Math.max(0, base + bonus);
        if (count > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)item, count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

