/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import net.fixerlink.compatapi.api.loot.CompatLootConditions;
import net.fixerlink.compatapi.compatapi;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;

public class CompatEnabledCondition
implements LootItemCondition {
    private final String owner;
    private final String target;

    public CompatEnabledCondition(String owner, String target) {
        this.owner = owner;
        this.target = target;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)CompatLootConditions.COMPAT_ENABLED.get();
    }

    public boolean test(LootContext ctx) {
        if (!ModList.get().isLoaded(this.target)) {
            return false;
        }
        Map<String, ForgeConfigSpec.BooleanValue> m = compatapi.TOGGLES.get(this.owner);
        if (m == null) {
            return false;
        }
        ForgeConfigSpec.BooleanValue v = m.get(this.target);
        return v != null && (Boolean)v.get() != false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<CompatEnabledCondition> {
        public void serialize(JsonObject json, CompatEnabledCondition value, JsonSerializationContext ctx) {
            json.addProperty("owner", value.owner);
            json.addProperty("target", value.target);
        }

        public CompatEnabledCondition deserialize(JsonObject json, JsonDeserializationContext ctx) {
            String owner = GsonHelper.m_13906_((JsonObject)json, (String)"owner");
            String target = GsonHelper.m_13906_((JsonObject)json, (String)"target");
            return new CompatEnabledCondition(owner, target);
        }
    }
}

