/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.fixerlink.compatapi.api.loot.MultiItemEntry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddMultiItemModifier
extends LootModifier {
    public static final Codec<AddMultiItemModifier> CODEC = RecordCodecBuilder.create(inst -> AddMultiItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)MultiItemEntry.CODEC.listOf().fieldOf("items").forGetter(m -> m.items)).apply((Applicative)inst, AddMultiItemModifier::new));
    private final List<MultiItemEntry> items;

    public AddMultiItemModifier(LootItemCondition[] conditions, List<MultiItemEntry> items) {
        super(conditions);
        this.items = items;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext ctx) {
        if (this.items.isEmpty()) {
            return generatedLoot;
        }
        RandomSource rnd = ctx.m_230907_();
        int totalWeight = this.items.stream().mapToInt(MultiItemEntry::weight).filter(w -> w > 0).sum();
        if (totalWeight <= 0) {
            return generatedLoot;
        }
        int roll = rnd.m_188503_(totalWeight);
        MultiItemEntry chosen = null;
        int acc = 0;
        for (MultiItemEntry e : this.items) {
            if (e.weight() <= 0 || roll >= (acc += e.weight())) continue;
            chosen = e;
            break;
        }
        if (chosen == null) {
            return generatedLoot;
        }
        Optional optItem = BuiltInRegistries.f_257033_.m_6612_(chosen.item());
        if (optItem.isEmpty()) {
            return generatedLoot;
        }
        Item item = (Item)optItem.get();
        int base = chosen.min() == chosen.max() ? chosen.min() : rnd.m_188503_(chosen.max() - chosen.min() + 1) + chosen.min();
        int looting = Math.max(0, ctx.getLootingModifier());
        int bonus = chosen.lootingBonusMax() > 0 ? rnd.m_188503_(chosen.lootingBonusMax() + 1) * looting : 0;
        int count = Math.max(0, base + bonus);
        if (count <= 0) {
            return generatedLoot;
        }
        generatedLoot.add((Object)new ItemStack((ItemLike)item, count));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

