/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MultiplyLootModifier
extends LootModifier {
    public static final Codec<MultiplyLootModifier> CODEC = RecordCodecBuilder.create(inst -> MultiplyLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.FLOAT.fieldOf("factor").forGetter(m -> Float.valueOf(m.factor))).apply((Applicative)inst, MultiplyLootModifier::new));
    private final float factor;

    public MultiplyLootModifier(LootItemCondition[] conditions, float factor) {
        super(conditions);
        this.factor = factor;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext ctx) {
        generatedLoot.removeIf(stack -> {
            int newCount = Math.round((float)stack.m_41613_() * this.factor);
            if (newCount <= 0) {
                return true;
            }
            stack.m_41764_(newCount);
            return false;
        });
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

