/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RemoveAllExceptModifier
extends LootModifier {
    public static final Codec<RemoveAllExceptModifier> CODEC = RecordCodecBuilder.create(inst -> RemoveAllExceptModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.f_135803_.listOf().fieldOf("whitelist").forGetter(m -> m.whitelistIds)).apply((Applicative)inst, RemoveAllExceptModifier::new));
    private final List<ResourceLocation> whitelistIds;

    public RemoveAllExceptModifier(LootItemCondition[] conditions, List<ResourceLocation> whitelistIds) {
        super(conditions);
        this.whitelistIds = whitelistIds;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext ctx) {
        HashSet allowed = new HashSet();
        for (ResourceLocation rl : this.whitelistIds) {
            BuiltInRegistries.f_257033_.m_6612_(rl).ifPresent(allowed::add);
        }
        if (allowed.isEmpty()) {
            return generatedLoot;
        }
        generatedLoot.removeIf(stack -> !allowed.contains(stack.m_41720_()));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

