/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi.api.loot.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class TransformItemModifier
extends LootModifier {
    public static final Codec<TransformItemModifier> CODEC = RecordCodecBuilder.create(inst -> TransformItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.f_135803_.optionalFieldOf("match_item").forGetter(m -> Optional.ofNullable(m.matchItem))).and((App)Codec.STRING.fieldOf("nbt").forGetter(m -> m.nbtString)).apply((Applicative)inst, (conds, matchOpt, nbtStr) -> new TransformItemModifier((LootItemCondition[])conds, matchOpt.orElse(null), (String)nbtStr)));
    private final ResourceLocation matchItem;
    private final String nbtString;
    private CompoundTag parsedTag;

    public TransformItemModifier(LootItemCondition[] conditions, ResourceLocation matchItem, String nbtString) {
        super(conditions);
        this.matchItem = matchItem;
        this.nbtString = nbtString;
    }

    private CompoundTag getTagSafe() {
        if (this.parsedTag != null) {
            return this.parsedTag;
        }
        try {
            this.parsedTag = TagParser.m_129359_((String)this.nbtString);
        }
        catch (Exception e) {
            this.parsedTag = new CompoundTag();
        }
        return this.parsedTag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext ctx) {
        for (ItemStack stack : generatedLoot) {
            CompoundTag tag;
            ResourceLocation key;
            if (stack.m_41619_() || this.matchItem != null && !this.matchItem.equals((Object)(key = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()))) || (tag = this.getTagSafe()).m_128456_()) continue;
            stack.m_41784_().m_128391_(tag.m_6426_());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

