/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatapi;

import com.mojang.logging.LogUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fixerlink.compatapi.api.CodeLoader;
import net.fixerlink.compatapi.api.CompatLog;
import net.fixerlink.compatapi.api.Discovery;
import net.fixerlink.compatapi.api.loot.CompatLootConditions;
import net.fixerlink.compatapi.api.loot.CompatLootModifiers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="compatapi")
public class compatapi {
    public static final String MOD_ID = "compatapi";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<String, Map<String, ForgeConfigSpec.BooleanValue>> TOGGLES = new LinkedHashMap<String, Map<String, ForgeConfigSpec.BooleanValue>>();

    public compatapi() {
        Discovery.scanAll();
        for (String owner : Discovery.OWNERS) {
            ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder().push("compat");
            LinkedHashMap<String, ForgeConfigSpec.BooleanValue> ownerToggles = new LinkedHashMap<String, ForgeConfigSpec.BooleanValue>();
            Set<String> modids = Discovery.getAllTargetsForOwner(owner);
            for (String modid : modids) {
                ownerToggles.put(modid, b.define(modid, true));
            }
            b.pop();
            ForgeConfigSpec spec = b.build();
            TOGGLES.put(owner, ownerToggles);
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, "compatapi-" + owner + ".toml");
        }
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        CompatLootConditions.register(modBus);
        CodeLoader.loadAll();
        CompatLootModifiers.GLM.register(modBus);
        CompatLog.info("CompatAPI ready. Owners: " + Discovery.OWNERS);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CodeLoader.loadAll());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="compatapi", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

