/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.capecommand;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.S2CConfigurationChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2696;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_7828;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.eclipseisoffline.capecommand.Cape;
import xyz.eclipseisoffline.capecommand.CapeCommandSuggestionProvider;
import xyz.eclipseisoffline.capecommand.CapeConfig;
import xyz.eclipseisoffline.capecommand.mixin.EntityAccessor;
import xyz.eclipseisoffline.capecommand.mixin.ServerChunkLoadingManagerAccessor;
import xyz.eclipseisoffline.capecommand.mixin.ServerConfigurationNetworkHandlerAccessor;
import xyz.eclipseisoffline.capecommand.mixin.ServerPlayerEntityAccessor;

public class CapeCommand
implements ModInitializer,
ClientModInitializer {
    public static final class_8710.class_9154<class_8710> INSTALLED_ID = new class_8710.class_9154(class_2960.method_60655((String)"capecommand", (String)"installed"));
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CapeCommand");
    public static final CapeConfig CONFIG = new CapeConfig();

    public void onInitialize() {
        LOGGER.info("Initialising cape command");
        LOGGER.info("Trying to load config, if it exists");
        CONFIG.readFromConfig();
        LOGGER.info("Registering cape command");
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cape").requires(class_2168::method_43737)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new CapeCommandSuggestionProvider()).executes(context -> {
            Cape cape;
            String capeString = StringArgumentType.getString((CommandContext)context, (String)"name");
            try {
                cape = Cape.valueOf(capeString.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Unknown cape")).create();
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (cape.requiresClient() && !CONFIG.hasCapeCommand(player)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"This cape requires you to install the Cape Command mod locally")).create();
            }
            CONFIG.setPlayerCape(((class_2168)context.getSource()).method_9207().method_7334(), cape);
            this.reloadPlayerSkin((class_2168)context.getSource());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Now wearing cape \"" + capeString.toLowerCase() + "\"")), true);
            if (CONFIG.isGeyserAvailable()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Note that this cape is only visible to you, bedrock players, and other Java players that have Cape Command installed"), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Note that this cape is only visible to you and other players that have Cape Command installed"), false);
            }
            return 0;
        }))).then(class_2170.method_9247((String)"reset").executes(context -> {
            CONFIG.resetPlayerCape(((class_2168)context.getSource()).method_9207().method_7334());
            this.reloadPlayerSkin((class_2168)context.getSource());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Cape reset"), true);
            return 0;
        }))));
        LOGGER.info("Registering server network handlers");
        S2CConfigurationChannelEvents.REGISTER.register((handler, sender, server, channels) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, INSTALLED_ID)) {
                GameProfile profile = ((ServerConfigurationNetworkHandlerAccessor)handler).getProfile();
                LOGGER.info("Player {} has cape commands installed client side", (Object)profile.name());
                CONFIG.registerCapeCommandPlayer(profile);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> CONFIG.unregisterCapeCommandPlayer(handler.method_32311()));
    }

    public void onInitializeClient() {
        LOGGER.info("Registering client network handlers");
        PayloadTypeRegistry.configurationS2C().register(INSTALLED_ID, (class_9139)new class_9139<class_2540, class_8710>(this){

            public class_8710 decode(class_2540 buf) {
                throw new AssertionError();
            }

            public void encode(class_2540 buf, class_8710 value) {
                throw new AssertionError();
            }
        });
        ClientConfigurationNetworking.registerGlobalReceiver(INSTALLED_ID, (payload, context) -> {});
    }

    private void reloadPlayerSkin(class_2168 source) throws CommandSyntaxException {
        class_3898 chunkManager = source.method_9225().method_14178().field_17254;
        class_3222 player = source.method_9207();
        class_3898.class_3208 trackedPlayer = (class_3898.class_3208)((ServerChunkLoadingManagerAccessor)chunkManager).getEntityTrackers().get(player.method_5628());
        for (class_3222 other : source.method_9211().method_3760().method_14571()) {
            boolean same;
            boolean bl = same = other == player;
            if (!same) {
                trackedPlayer.method_18733(other);
            }
            other.field_13987.method_14364((class_2596)new class_7828(List.of(player.method_5667())));
            other.field_13987.method_14364((class_2596)class_2703.method_43886(List.of(player)));
            if (same) {
                player.field_7498.method_7595((class_1657)player);
                if (player.field_7512 != null && player.method_45015()) {
                    player.method_14247();
                }
                player.field_13987.method_14364((class_2596)new class_2724(other.method_52374(source.method_9225()), 3));
                player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
                player.field_13987.method_14372();
                source.method_9225().method_18770(player, class_1297.class_5529.field_27002);
                ((EntityAccessor)player).invokeUnsetRemoved();
                source.method_9225().method_18769((class_1297)player);
                player.method_6021();
                player.field_13987.method_14364((class_2596)new class_2696(player.method_31549()));
                source.method_9211().method_3760().method_14606(player, source.method_9225());
                source.method_9211().method_3760().method_14594(player);
                source.method_9211().method_3760().method_60598(player);
                ((ServerPlayerEntityAccessor)player).setSyncedExperience(-1);
                ((ServerPlayerEntityAccessor)player).setSyncedHealth(-1.0f);
                ((ServerPlayerEntityAccessor)player).setSyncedFoodLevel(-1);
                continue;
            }
            trackedPlayer.method_18736(other);
        }
    }
}

