/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.capecommand;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import org.geysermc.geyser.api.GeyserApi;
import xyz.eclipseisoffline.capecommand.Cape;
import xyz.eclipseisoffline.capecommand.CapeCommand;

public class CapeConfig {
    private static final Path CONFIG_FILE = Path.of("playercapes.json", new String[0]);
    private final Map<UUID, Cape> playerCapes = new HashMap<UUID, Cape>();
    private final List<GameProfile> capeCommandPlayers = new ArrayList<GameProfile>();
    private final boolean geyserAvailable;

    public CapeConfig() {
        boolean geyserAvailable;
        try {
            Class.forName("org.geysermc.geyser.api.GeyserApi");
            geyserAvailable = true;
            CapeCommand.LOGGER.info("Geyser compatibility enabled!");
        }
        catch (ClassNotFoundException | NoClassDefFoundError error) {
            geyserAvailable = false;
        }
        this.geyserAvailable = geyserAvailable;
    }

    public Cape getPlayerCape(GameProfile gameProfile) {
        return this.playerCapes.get(gameProfile.id());
    }

    public void setPlayerCape(GameProfile gameProfile, Cape cape) {
        this.playerCapes.put(gameProfile.id(), cape);
        this.writeToConfig();
    }

    public void resetPlayerCape(GameProfile gameProfile) {
        this.playerCapes.remove(gameProfile.id());
        this.writeToConfig();
    }

    public void registerCapeCommandPlayer(GameProfile serverPlayerEntity) {
        this.capeCommandPlayers.add(serverPlayerEntity);
    }

    public boolean hasCapeCommand(class_3222 serverPlayerEntity) {
        return this.capeCommandPlayers.contains(serverPlayerEntity.method_7334()) || this.geyserAvailable && GeyserApi.api().isBedrockPlayer(serverPlayerEntity.method_5667());
    }

    public void unregisterCapeCommandPlayer(class_3222 serverPlayerEntity) {
        this.capeCommandPlayers.remove(serverPlayerEntity.method_7334());
    }

    public boolean isGeyserAvailable() {
        return this.geyserAvailable;
    }

    private void writeToConfig() {
        JsonObject capesJson = new JsonObject();
        for (Map.Entry<UUID, Cape> playerCape : this.playerCapes.entrySet()) {
            capesJson.addProperty(playerCape.getKey().toString(), playerCape.getValue().toString());
        }
        Path capeConfigPath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE);
        try {
            Files.writeString(capeConfigPath, (CharSequence)capesJson.toString(), new OpenOption[0]);
        }
        catch (IOException exception) {
            CapeCommand.LOGGER.warn("Failed to save player cape config!", (Throwable)exception);
        }
    }

    public void readFromConfig() {
        Path capeConfigPath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE);
        if (Files.exists(capeConfigPath, new LinkOption[0])) {
            try {
                JsonObject capesJson = JsonParser.parseString((String)Files.readString(capeConfigPath)).getAsJsonObject();
                for (Map.Entry playerCape : capesJson.entrySet()) {
                    try {
                        this.playerCapes.put(UUID.fromString((String)playerCape.getKey()), Cape.valueOf(((JsonElement)playerCape.getValue()).getAsString()));
                    }
                    catch (IllegalArgumentException exception) {
                        CapeCommand.LOGGER.warn("Read invalid cape for UUID {}! ({})", playerCape.getKey(), (Object)((JsonElement)playerCape.getValue()).getAsString());
                    }
                }
            }
            catch (IOException exception) {
                CapeCommand.LOGGER.warn("Failed to read player cape config!", (Throwable)exception);
            }
        }
    }
}

