/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.MergePolicy;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.util.InfoStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

class CachingMergeContext
implements MergePolicy.MergeContext {
    final MergePolicy.MergeContext mergeContext;
    final HashMap<SegmentCommitInfo, Integer> cachedNumDeletesToMerge = new HashMap();

    CachingMergeContext(MergePolicy.MergeContext mergeContext) {
        this.mergeContext = mergeContext;
    }

    @Override
    public final int numDeletesToMerge(SegmentCommitInfo info) throws IOException {
        Integer numDeletesToMerge = this.cachedNumDeletesToMerge.get(info);
        if (numDeletesToMerge != null) {
            return numDeletesToMerge;
        }
        numDeletesToMerge = this.mergeContext.numDeletesToMerge(info);
        this.cachedNumDeletesToMerge.put(info, numDeletesToMerge);
        return numDeletesToMerge;
    }

    @Override
    public final int numDeletedDocs(SegmentCommitInfo info) {
        return this.mergeContext.numDeletedDocs(info);
    }

    @Override
    public final InfoStream getInfoStream() {
        return this.mergeContext.getInfoStream();
    }

    @Override
    public final Set<SegmentCommitInfo> getMergingSegments() {
        return this.mergeContext.getMergingSegments();
    }
}

