/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.server.i18n;

import com.iafenvoy.server.i18n.ServerI18nReloader;
import com.iafenvoy.server.i18n.util.ServerPlayerEntityAccessor;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class ServerI18n {
    public static final String DEFAULT_LANGUAGE = "en_us";

    public static Component translateToLiteral(ServerPlayer player, String key, String ... format) {
        return ServerI18n.translateToLiteral(((ServerPlayerEntityAccessor)player).server_i18n_api$getLanguage(), key, format);
    }

    public static Component translateToLiteral(String language, String key, String ... format) {
        return Component.literal((String)ServerI18n.translate(language, key, format));
    }

    public static Component translateToLiteral(CommandSourceStack source, String key, String ... format) throws CommandSyntaxException {
        return source.isPlayer() ? ServerI18n.translateToLiteral(source.getPlayerOrException(), key, format) : ServerI18n.translateToLiteral(DEFAULT_LANGUAGE, key, format);
    }

    public static String translate(ServerPlayer player, String key, String ... format) {
        return ServerI18n.translate(((ServerPlayerEntityAccessor)player).server_i18n_api$getLanguage(), key, format);
    }

    public static String translate(String language, String key, String ... format) {
        return ServerI18nReloader.translate(language, key).formatted(format);
    }

    public static String translate(CommandSourceStack source, String key, String ... format) throws CommandSyntaxException {
        return source.isPlayer() ? ServerI18n.translate(source.getPlayerOrException(), key, format) : ServerI18n.translate(DEFAULT_LANGUAGE, key, format);
    }

    public static void sendMessage(CommandSourceStack source, String key, String ... format) throws CommandSyntaxException {
        source.sendSystemMessage(ServerI18n.translateToLiteral(source, key, format));
    }

    public static void sendMessage(ServerPlayer player, String key, String ... format) {
        player.sendSystemMessage(ServerI18n.translateToLiteral(player, key, format));
    }

    public static void broadcast(MinecraftServer server, String key, String ... format) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            ServerI18n.sendMessage(player, key, format);
        }
    }
}

