/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.server.i18n;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iafenvoy.server.i18n.ServerI18nApi;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public enum ServerI18nReloader implements ResourceManagerReloadListener
{
    INSTANCE;

    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final Map<String, Map<String, String>> DATA;

    public void onResourceManagerReload(ResourceManager manager) {
        DATA.clear();
        for (Map.Entry entry : manager.listResources("lang", p -> p.getPath().endsWith(".json")).entrySet()) {
            String language = ((ResourceLocation)entry.getKey()).getPath().replaceAll(".json", "").replaceAll("lang/", "");
            if (!DATA.containsKey(language)) {
                DATA.put(language, new HashMap());
            }
            Map<String, String> map = DATA.get(language);
            try {
                JsonElement element = JsonParser.parseReader((Reader)((Resource)entry.getValue()).openAsReader());
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                for (String s : obj.keySet()) {
                    map.put(s, obj.get(s).getAsString());
                }
            }
            catch (Exception e) {
                ServerI18nApi.LOGGER.error("Failed to load {}", (Object)((ResourceLocation)entry.getKey()).toString(), (Object)e);
            }
        }
    }

    public static String translate(String language, String key) {
        Map<String, String> map;
        if (DATA.containsKey(language) && (map = DATA.get(language)).containsKey(key)) {
            return DATA.get(language).get(key);
        }
        if (DATA.containsKey(DEFAULT_LANGUAGE)) {
            return DATA.get(DEFAULT_LANGUAGE).getOrDefault(key, key);
        }
        return key;
    }

    static {
        DATA = new HashMap<String, Map<String, String>>();
    }
}

