/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.server.i18n;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iafenvoy.server.i18n.ServerI18nApi;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public enum ServerI18nReloader implements class_4013
{
    INSTANCE;

    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final Map<String, Map<String, String>> DATA;

    public void method_14491(class_3300 manager) {
        DATA.clear();
        for (Map.Entry entry : manager.method_14488("lang", p -> p.method_12832().endsWith(".json")).entrySet()) {
            String language = ((class_2960)entry.getKey()).method_12832().replaceAll(".json", "").replaceAll("lang/", "");
            if (!DATA.containsKey(language)) {
                DATA.put(language, new HashMap());
            }
            Map<String, String> map = DATA.get(language);
            try {
                JsonElement element = JsonParser.parseReader((Reader)((class_3298)entry.getValue()).method_43039());
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                for (String s : obj.keySet()) {
                    map.put(s, obj.get(s).getAsString());
                }
            }
            catch (Exception e) {
                ServerI18nApi.LOGGER.error("Failed to load {}", (Object)((class_2960)entry.getKey()).toString(), (Object)e);
            }
        }
    }

    public static String translate(String language, String key) {
        Map<String, String> map;
        if (DATA.containsKey(language) && (map = DATA.get(language)).containsKey(key)) {
            return DATA.get(language).get(key);
        }
        if (DATA.containsKey(DEFAULT_LANGUAGE)) {
            return DATA.get(DEFAULT_LANGUAGE).getOrDefault(key, key);
        }
        return key;
    }

    static {
        DATA = new HashMap<String, Map<String, String>>();
    }
}

