package com.boyonk.pine.client.data;

import com.boyonk.pine.block.PineBlocks;
import com.boyonk.pine.client.PineModClient;
import com.boyonk.pine.item.PineItems;
import com.boyonk.pine.registry.tag.PineBlockTags;
import com.boyonk.pine.registry.tag.PineItemTags;
import com.boyonk.pine.world.gen.feature.PineConfiguredFeatures;
import com.boyonk.pine.world.gen.feature.PinePlacedFeatures;
import com.boyonk.pine.world.gen.treedecorator.AlterTopTrunkTreeDecorator;
import com.google.common.collect.ImmutableList;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4643;
import net.minecraft.class_4649;
import net.minecraft.class_4651;
import net.minecraft.class_4658;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_4946;
import net.minecraft.class_5140;
import net.minecraft.class_5204;
import net.minecraft.class_5210;
import net.minecraft.class_5214;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6658;
import net.minecraft.class_6794;
import net.minecraft.class_6796;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_7225;
import net.minecraft.class_7701;
import net.minecraft.class_7871;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.minecraft.registry.*;
import net.minecraft.world.gen.feature.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.concurrent.CompletableFuture;

public class PineDataGenerator implements DataGeneratorEntrypoint {

	public static final class_5794 PINE_FAMILY = class_5793.method_33468(PineBlocks.PINE_PLANKS).method_33482(PineBlocks.PINE_BUTTON).method_33490(PineBlocks.PINE_FENCE).method_33491(PineBlocks.PINE_FENCE_GATE).method_33494(PineBlocks.PINE_PRESSURE_PLATE).method_33483(PineBlocks.PINE_SIGN, PineBlocks.PINE_WALL_SIGN).method_33492(PineBlocks.PINE_SLAB).method_33493(PineBlocks.PINE_STAIRS).method_33489(PineBlocks.PINE_DOOR).method_33496(PineBlocks.PINE_TRAPDOOR).method_33484("wooden").method_33487("has_planks").method_33481();

	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		FabricDataGenerator.Pack pack = generator.createPack();
		pack.addProvider(PineModelProvider::new);
		pack.addProvider(PineBlockLootTableProvider::new);
		pack.addProvider(PineRecipeProvider::new);
		PineBlockTagProvider blockTagProvider = pack.addProvider(PineBlockTagProvider::new);
		pack.addProvider(((output, registriesFuture) -> new PineItemTagProvider(output, registriesFuture, blockTagProvider)));
		pack.addProvider(PineConfiguredFeatureProvider::new);
		pack.addProvider(PinePlacedFeatureProvider::new);
		pack.addProvider(PineEnLanguageProvider::new);
		pack.addProvider(PineNlLanguageProvider::new);
	}

	@Override
	public void buildRegistry(class_7877 registryBuilder) {
		registryBuilder.method_46777(class_7924.field_41239, PineConfiguredFeatureProvider::bootstrap);
		registryBuilder.method_46777(class_7924.field_41245, PinePlacedFeatureProvider::bootstrap);
	}

	private static class PineModelProvider extends FabricModelProvider {

		public PineModelProvider(FabricDataOutput output) {
			super(output);
		}

		@Override
		public void generateBlockStateModels(class_4910 generator) {
			generator.method_25650(PineBlocks.PINE_PLANKS).method_33522(PINE_FAMILY);
			generator.method_25676(PineBlocks.PINE_LOG).method_25730(PineBlocks.PINE_LOG).method_25728(PineBlocks.PINE_WOOD);
			generator.method_25676(PineBlocks.STRIPPED_PINE_LOG).method_25730(PineBlocks.STRIPPED_PINE_LOG).method_25728(PineBlocks.STRIPPED_PINE_WOOD);
			generator.method_46190(PineBlocks.STRIPPED_PINE_LOG, PineBlocks.PINE_HANGING_SIGN, PineBlocks.PINE_WALL_HANGING_SIGN);
			generator.method_65407(PineBlocks.PINE_SAPLING, PineBlocks.POTTED_PINE_SAPLING, class_4910.class_4913.field_22840);
			generator.method_65408(PineBlocks.PINE_LEAVES, class_4946.field_23049, PineModClient.PINE_LEAVES_COLOR);
		}

		@Override
		public void generateItemModels(class_4915 generator) {
			generator.method_65442(PineItems.PINE_BOAT, class_4943.field_22938);
			generator.method_65442(PineItems.PINE_CHEST_BOAT, class_4943.field_22938);
		}
	}


	private static class PineBlockLootTableProvider extends FabricBlockLootTableProvider {

		protected PineBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, registryLookup);
		}

		@Override
		public void method_10379() {
			this.method_46025(PineBlocks.PINE_PLANKS);
			this.method_46025(PineBlocks.PINE_SAPLING);
			this.method_46025(PineBlocks.PINE_LOG);
			this.method_46025(PineBlocks.STRIPPED_PINE_LOG);
			this.method_46025(PineBlocks.PINE_WOOD);
			this.method_46025(PineBlocks.STRIPPED_PINE_WOOD);
			this.method_46025(PineBlocks.PINE_SIGN);
			this.method_46025(PineBlocks.PINE_HANGING_SIGN);
			this.method_46025(PineBlocks.PINE_PRESSURE_PLATE);
			this.method_46025(PineBlocks.PINE_TRAPDOOR);
			this.method_46025(PineBlocks.PINE_STAIRS);
			this.method_46025(PineBlocks.PINE_BUTTON);
			this.method_46025(PineBlocks.PINE_FENCE_GATE);
			this.method_46025(PineBlocks.PINE_FENCE);
			this.method_46023(PineBlocks.POTTED_PINE_SAPLING);
			this.method_45994(PineBlocks.PINE_SLAB, this::method_45980);
			this.method_45994(PineBlocks.PINE_DOOR, this::method_46022);
			this.method_45994(PineBlocks.PINE_LEAVES, (class_2248 block) -> this.method_45986(block, PineBlocks.PINE_SAPLING, field_40605));
		}
	}

	private static class PineRecipeProvider extends FabricRecipeProvider {

		public PineRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected class_2446 method_62766(class_7225.class_7874 registryLookup, class_8790 exporter) {
			return new class_2446(registryLookup, exporter) {
				@Override
				public void method_10419() {
					this.method_33535(PINE_FAMILY, class_7701.field_40183);
					this.method_24477(PineBlocks.PINE_PLANKS, PineItemTags.PINE_LOGS, 4);
					this.method_24476(PineBlocks.PINE_WOOD, PineBlocks.PINE_LOG);
					this.method_24476(PineBlocks.STRIPPED_PINE_WOOD, PineBlocks.STRIPPED_PINE_LOG);
					this.method_24478(PineItems.PINE_BOAT, PineBlocks.PINE_PLANKS);
					this.method_42754(PineItems.PINE_CHEST_BOAT, PineItems.PINE_BOAT);
					this.method_46208(PineItems.PINE_HANGING_SIGN, PineBlocks.STRIPPED_PINE_LOG);
				}
			};
		}

		@Override
		public String method_10321() {
			return "Recipes";
		}
	}

	private static class PineBlockTagProvider extends FabricTagProvider.BlockTagProvider {

		public PineBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected void method_10514(class_7225.class_7874 wrapperLookup) {
			this.valueLookupBuilder(class_3481.field_15471).method_71554(PineBlocks.PINE_PLANKS);
			this.valueLookupBuilder(class_3481.field_15499).method_71554(PineBlocks.PINE_BUTTON);
			this.valueLookupBuilder(class_3481.field_15494).method_71554(PineBlocks.PINE_DOOR);
			this.valueLookupBuilder(class_3481.field_15502).method_71554(PineBlocks.PINE_STAIRS);
			this.valueLookupBuilder(class_3481.field_15468).method_71554(PineBlocks.PINE_SLAB);
			this.valueLookupBuilder(class_3481.field_17619).method_71554(PineBlocks.PINE_FENCE);
			this.valueLookupBuilder(class_3481.field_15462).method_71554(PineBlocks.PINE_SAPLING);
			this.valueLookupBuilder(PineBlockTags.PINE_LOGS).method_71558(PineBlocks.PINE_LOG, PineBlocks.PINE_WOOD, PineBlocks.STRIPPED_PINE_LOG, PineBlocks.STRIPPED_PINE_WOOD);
			this.valueLookupBuilder(class_3481.field_23210).method_71553(PineBlockTags.PINE_LOGS);
			this.valueLookupBuilder(class_3481.field_39030).method_71554(PineBlocks.PINE_LOG);
			this.valueLookupBuilder(class_3481.field_15470).method_71554(PineBlocks.POTTED_PINE_SAPLING);
			this.valueLookupBuilder(class_3481.field_15477).method_71554(PineBlocks.PINE_PRESSURE_PLATE);
			this.valueLookupBuilder(class_3481.field_15503).method_71554(PineBlocks.PINE_LEAVES);
			this.valueLookupBuilder(class_3481.field_15491).method_71554(PineBlocks.PINE_TRAPDOOR);
			this.valueLookupBuilder(class_3481.field_15472).method_71554(PineBlocks.PINE_SIGN);
			this.valueLookupBuilder(class_3481.field_15492).method_71554(PineBlocks.PINE_WALL_SIGN);
			this.valueLookupBuilder(class_3481.field_40103).method_71554(PineBlocks.PINE_HANGING_SIGN);
			this.valueLookupBuilder(class_3481.field_40104).method_71554(PineBlocks.PINE_WALL_HANGING_SIGN);
			this.valueLookupBuilder(class_3481.field_25147).method_71554(PineBlocks.PINE_FENCE_GATE);
			this.valueLookupBuilder(class_3481.field_33714).method_71554(PineBlocks.PINE_LEAVES);

		}
	}

	private static class PineItemTagProvider extends FabricTagProvider.ItemTagProvider {

		public PineItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable FabricTagProvider.BlockTagProvider blockTagProvider) {
			super(output, completableFuture, blockTagProvider);
		}

		@Override
		protected void method_10514(class_7225.class_7874 wrapperLookup) {
			this.copy(class_3481.field_15471, class_3489.field_15537);
			this.copy(class_3481.field_15499, class_3489.field_15555);
			this.copy(class_3481.field_15494, class_3489.field_15552);
			this.copy(class_3481.field_15502, class_3489.field_15557);
			this.copy(class_3481.field_15468, class_3489.field_15534);
			this.copy(class_3481.field_17619, class_3489.field_17620);
			this.copy(class_3481.field_15462, class_3489.field_15528);
			this.copy(PineBlockTags.PINE_LOGS, PineItemTags.PINE_LOGS);
			this.copy(class_3481.field_23210, class_3489.field_23212);
			this.copy(class_3481.field_15477, class_3489.field_15540);
			this.copy(class_3481.field_15503, class_3489.field_15558);
			this.copy(class_3481.field_15491, class_3489.field_15550);
			this.copy(class_3481.field_25147, class_3489.field_40858);

			this.valueLookupBuilder(class_3489.field_15536).method_71554(PineItems.PINE_BOAT);
			this.valueLookupBuilder(class_3489.field_38080).method_71554(PineItems.PINE_CHEST_BOAT);
		}
	}

	private static class PineConfiguredFeatureProvider extends FabricDynamicRegistryProvider {

		public PineConfiguredFeatureProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
			super(dataOutput, registryLookupFuture);
		}

		@Override
		protected void configure(class_7225.class_7874 registries, Entries entries) {
			entries.add(registries.method_46762(class_7924.field_41239), PineConfiguredFeatures.PINE);
			entries.add(registries.method_46762(class_7924.field_41239), PineConfiguredFeatures.MEGA_PINE);
		}

		@Override
		public String method_10321() {
			return "Configured Features";
		}

		public static void bootstrap(class_7891<class_2975<?, ?>> registerable) {
			class_6803.method_39708(registerable, PineConfiguredFeatures.PINE, class_3031.field_24134,
					new class_4643.class_4644(
							class_4651.method_38432(PineBlocks.PINE_LOG),
							new class_5140(6, 4, 0),
							class_4651.method_38432(PineBlocks.PINE_LEAVES),
							new class_4649(class_6016.method_34998(1), class_6016.method_34998(1), class_6019.method_35017(3, 4)),
							new class_5204(2, 0, 2)
					)
							.method_27376(ImmutableList.of(new AlterTopTrunkTreeDecorator(class_4651.method_38432(PineBlocks.STRIPPED_PINE_LOG), class_6019.method_35017(-1, 2), 0.9f, 0.5f)))
							.method_27374()
							.method_23445()
			);

			class_6803.method_39708(registerable, PineConfiguredFeatures.MEGA_PINE, class_3031.field_24134,
					new class_4643.class_4644(
							class_4651.method_38432(PineBlocks.PINE_LOG),
							new class_5214(13, 2, 14),
							class_4651.method_38432(PineBlocks.PINE_LEAVES),
							new class_5210(class_6016.method_34998(0), class_6016.method_34998(0), class_6019.method_35017(3, 7)),
							new class_5204(1, 1, 2)
					)
							.method_27376(ImmutableList.of(new class_4658(class_4651.method_38432(class_2246.field_10520)), new AlterTopTrunkTreeDecorator(class_4651.method_38432(PineBlocks.STRIPPED_PINE_LOG), class_6019.method_35017(-1, 3), 0.9f, 0.5f)))
							.method_23445()
			);

		}

	}

	private static class PinePlacedFeatureProvider extends FabricDynamicRegistryProvider {

		public PinePlacedFeatureProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
			super(dataOutput, registryLookupFuture);
		}

		@Override
		protected void configure(class_7225.class_7874 registries, Entries entries) {
			entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.PINE_ON_SNOW);
			entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.PINE_CHECKED);
			entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.MEGA_PINE_CHECKED);
		}


		public static void bootstrap(class_7891<class_6796> registerable) {
			class_7871<class_2975<?, ?>> registryLookup = registerable.method_46799(class_7924.field_41239);
			class_6817.method_39737(registerable, PinePlacedFeatures.PINE_ON_SNOW, registryLookup.method_46747(PineConfiguredFeatures.PINE), List.of(class_6794.method_39628(class_2350.field_11036, class_6646.method_38877(class_6646.method_43290(class_2246.field_27879)), 8), class_6658.method_39618(class_6646.method_43288(class_2350.field_11033.method_62675(), class_2246.field_10491, class_2246.field_27879))));
			class_6817.method_40370(registerable, PinePlacedFeatures.PINE_CHECKED, registryLookup.method_46747(PineConfiguredFeatures.PINE), class_6817.method_40365(PineBlocks.PINE_SAPLING));
			class_6817.method_40370(registerable, PinePlacedFeatures.MEGA_PINE_CHECKED, registryLookup.method_46747(PineConfiguredFeatures.MEGA_PINE), class_6817.method_40365(PineBlocks.PINE_SAPLING));
		}


		@Override
		public String method_10321() {
			return "Placed Features";
		}
	}

	private static class PineEnLanguageProvider extends FabricLanguageProvider {


		protected PineEnLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "en_us", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			builder.add(PineBlocks.PINE_PLANKS, "Pine Planks");
			builder.add(PineBlocks.PINE_SAPLING, "Pine Sapling");
			builder.add(PineBlocks.PINE_LOG, "Pine Log");
			builder.add(PineBlocks.STRIPPED_PINE_LOG, "Stripped Pine Log");
			builder.add(PineBlocks.PINE_WOOD, "Pine Wood");
			builder.add(PineBlocks.STRIPPED_PINE_WOOD, "Stripped Pine Wood");
			builder.add(PineBlocks.PINE_LEAVES, "Pine Leaves");
			builder.add(PineBlocks.PINE_SIGN, "Pine Sign");
			builder.add(PineBlocks.PINE_HANGING_SIGN, "Pine Hanging Sign");
			builder.add(PineBlocks.PINE_PRESSURE_PLATE, "Pine Pressure Plate");
			builder.add(PineBlocks.PINE_TRAPDOOR, "Pine Trapdoor");
			builder.add(PineBlocks.PINE_STAIRS, "Pine Stairs");
			builder.add(PineBlocks.POTTED_PINE_SAPLING, "Potted Pine Sapling");
			builder.add(PineBlocks.PINE_BUTTON, "Pine Button");
			builder.add(PineBlocks.PINE_SLAB, "Pine Slab");
			builder.add(PineBlocks.PINE_FENCE_GATE, "Pine Fence Gate");
			builder.add(PineBlocks.PINE_FENCE, "Pine Fence");
			builder.add(PineBlocks.PINE_DOOR, "Pine Door");
			builder.add(PineItems.PINE_BOAT, "Pine Boat");
			builder.add(PineItems.PINE_CHEST_BOAT, "Pine Chest Boat");

		}
	}

	private static class PineNlLanguageProvider extends FabricLanguageProvider {


		protected PineNlLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "nl_nl", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			builder.add(PineBlocks.PINE_PLANKS, "Dennenhouten planken");
			builder.add(PineBlocks.PINE_SAPLING, "Dennenzaailing");
			builder.add(PineBlocks.PINE_LOG, "Dennenstam");
			builder.add(PineBlocks.STRIPPED_PINE_LOG, "Gestripte dennenstam");
			builder.add(PineBlocks.PINE_WOOD, "Dennenhout");
			builder.add(PineBlocks.STRIPPED_PINE_WOOD, "Gestripte dennenhout");
			builder.add(PineBlocks.PINE_LEAVES, "Dennennaalden");
			builder.add(PineBlocks.PINE_SIGN, "Dennenhouten bord");
			builder.add(PineBlocks.PINE_HANGING_SIGN, "Dennenhouten hangbord");
			builder.add(PineBlocks.PINE_PRESSURE_PLATE, "Dennenhouten drukplaat");
			builder.add(PineBlocks.PINE_TRAPDOOR, "Dennenhouten valluik");
			builder.add(PineBlocks.PINE_STAIRS, "Dennenhouten trap");
			builder.add(PineBlocks.POTTED_PINE_SAPLING, "Opgepotte dennenzaailing");
			builder.add(PineBlocks.PINE_BUTTON, "Dennenhouten knop");
			builder.add(PineBlocks.PINE_SLAB, "Dennenhouten plaat");
			builder.add(PineBlocks.PINE_FENCE_GATE, "Dennenhouten poort");
			builder.add(PineBlocks.PINE_FENCE, "Dennenhouten hek");
			builder.add(PineBlocks.PINE_DOOR, "Dennenhouten deur");
			builder.add(PineItems.PINE_BOAT, "Dennenhouten boot");
			builder.add(PineItems.PINE_CHEST_BOAT, "Dennenhouten boot met kist");
		}
	}

}
