package com.boyonk.pine.world.gen.treedecorator;

import com.boyonk.pine.PineMod;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5819;
import net.minecraft.class_6017;


public class AlterTopTrunkTreeDecorator extends class_4662 {

	public static final MapCodec<AlterTopTrunkTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance ->
			instance.group(
					class_4651.field_24937
							.fieldOf("provider")
							.forGetter(decorator -> decorator.provider),
					class_6017.field_29946
							.fieldOf("distance_from_leaves")
							.forGetter(decorator -> decorator.distance),
					Codec.floatRange(0, 1)
							.fieldOf("in_leaves_chance")
							.forGetter(decorator -> decorator.leavesChance),
					Codec.floatRange(0, 1)
							.fieldOf("exposed_chance")
							.forGetter(decorator -> decorator.exposedChance)
			).apply(instance, AlterTopTrunkTreeDecorator::new)
	);

	private final class_4651 provider;
	private final class_6017 distance;
	private final float leavesChance;
	private final float exposedChance;

	public AlterTopTrunkTreeDecorator(class_4651 provider, class_6017 distance, float leavesChance, float exposedChance) {
		this.provider = provider;
		this.distance = distance;
		this.leavesChance = leavesChance;
		this.exposedChance = exposedChance;
	}

	@Override
	protected class_4663<?> method_28893() {
		return PineMod.ALTER_TRUNK_TREE_DECORATOR;
	}

	@Override
	public void method_23469(class_7402 generator) {
		class_5819 random = generator.method_43320();

		ObjectArrayList<class_2338> logPositions = generator.method_43321();
		if (logPositions.isEmpty()) return;
		ObjectArrayList<class_2338> leavesPositions = generator.method_43322();
		if (leavesPositions.isEmpty()) return;
		int leavesBase = leavesPositions.getFirst().method_10264();
		int end = leavesBase - distance.method_35008(random);

		for (int i = logPositions.size() - 1; i >= 0; i--) {
			class_2338 pos = logPositions.get(i);
			if (pos.method_10264() < end) return;
			if (random.method_43057() < (pos.method_10264() >= leavesBase ? this.leavesChance : this.exposedChance)) {
				generator.method_43318(pos, this.provider.method_23455(random, pos));
			}
		}
	}

}
