/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.pine.client.data;

import com.boyonk.pine.block.PineBlocks;
import com.boyonk.pine.item.PineItems;
import com.boyonk.pine.registry.tag.PineBlockTags;
import com.boyonk.pine.registry.tag.PineItemTags;
import com.boyonk.pine.world.gen.feature.PineConfiguredFeatures;
import com.boyonk.pine.world.gen.feature.PinePlacedFeatures;
import com.boyonk.pine.world.gen.treedecorator.AlterTopTrunkTreeDecorator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2446;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4649;
import net.minecraft.class_4651;
import net.minecraft.class_4658;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_4946;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5210;
import net.minecraft.class_5214;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6658;
import net.minecraft.class_6794;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7701;
import net.minecraft.class_7871;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PineDataGenerator
implements DataGeneratorEntrypoint {
    public static final class_5794 PINE_FAMILY = class_5793.method_33468((class_2248)PineBlocks.PINE_PLANKS).method_33482(PineBlocks.PINE_BUTTON).method_33490(PineBlocks.PINE_FENCE).method_33491(PineBlocks.PINE_FENCE_GATE).method_33494(PineBlocks.PINE_PRESSURE_PLATE).method_33483(PineBlocks.PINE_SIGN, PineBlocks.PINE_WALL_SIGN).method_33492(PineBlocks.PINE_SLAB).method_33493(PineBlocks.PINE_STAIRS).method_33489(PineBlocks.PINE_DOOR).method_33496(PineBlocks.PINE_TRAPDOOR).method_33484("wooden").method_33487("has_planks").method_33481();

    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        FabricDataGenerator.Pack pack = generator.createPack();
        pack.addProvider(PineModelProvider::new);
        pack.addProvider(PineBlockLootTableProvider::new);
        pack.addProvider(PineRecipeProvider::new);
        PineBlockTagProvider blockTagProvider = (PineBlockTagProvider)pack.addProvider(PineBlockTagProvider::new);
        pack.addProvider((output, registriesFuture) -> new PineItemTagProvider(output, registriesFuture, blockTagProvider));
        pack.addProvider(PineConfiguredFeatureProvider::new);
        pack.addProvider(PinePlacedFeatureProvider::new);
        pack.addProvider(PineEnLanguageProvider::new);
        pack.addProvider(PineNlLanguageProvider::new);
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, PineConfiguredFeatureProvider::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, PinePlacedFeatureProvider::bootstrap);
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineBlockTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public PineBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.valueLookupBuilder(class_3481.field_15471).method_71554((Object)PineBlocks.PINE_PLANKS);
            this.valueLookupBuilder(class_3481.field_15499).method_71554((Object)PineBlocks.PINE_BUTTON);
            this.valueLookupBuilder(class_3481.field_15494).method_71554((Object)PineBlocks.PINE_DOOR);
            this.valueLookupBuilder(class_3481.field_15502).method_71554((Object)PineBlocks.PINE_STAIRS);
            this.valueLookupBuilder(class_3481.field_15468).method_71554((Object)PineBlocks.PINE_SLAB);
            this.valueLookupBuilder(class_3481.field_17619).method_71554((Object)PineBlocks.PINE_FENCE);
            this.valueLookupBuilder(class_3481.field_15462).method_71554((Object)PineBlocks.PINE_SAPLING);
            this.valueLookupBuilder(PineBlockTags.PINE_LOGS).method_71558((Object[])new class_2248[]{PineBlocks.PINE_LOG, PineBlocks.PINE_WOOD, PineBlocks.STRIPPED_PINE_LOG, PineBlocks.STRIPPED_PINE_WOOD});
            this.valueLookupBuilder(class_3481.field_23210).method_71553(PineBlockTags.PINE_LOGS);
            this.valueLookupBuilder(class_3481.field_39030).method_71554((Object)PineBlocks.PINE_LOG);
            this.valueLookupBuilder(class_3481.field_15470).method_71554((Object)PineBlocks.POTTED_PINE_SAPLING);
            this.valueLookupBuilder(class_3481.field_15477).method_71554((Object)PineBlocks.PINE_PRESSURE_PLATE);
            this.valueLookupBuilder(class_3481.field_15503).method_71554((Object)PineBlocks.PINE_LEAVES);
            this.valueLookupBuilder(class_3481.field_15491).method_71554((Object)PineBlocks.PINE_TRAPDOOR);
            this.valueLookupBuilder(class_3481.field_15472).method_71554((Object)PineBlocks.PINE_SIGN);
            this.valueLookupBuilder(class_3481.field_15492).method_71554((Object)PineBlocks.PINE_WALL_SIGN);
            this.valueLookupBuilder(class_3481.field_40103).method_71554((Object)PineBlocks.PINE_HANGING_SIGN);
            this.valueLookupBuilder(class_3481.field_40104).method_71554((Object)PineBlocks.PINE_WALL_HANGING_SIGN);
            this.valueLookupBuilder(class_3481.field_25147).method_71554((Object)PineBlocks.PINE_FENCE_GATE);
            this.valueLookupBuilder(class_3481.field_33714).method_71554((Object)PineBlocks.PINE_LEAVES);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineItemTagProvider
    extends FabricTagProvider.ItemTagProvider {
        public PineItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable FabricTagProvider.BlockTagProvider blockTagProvider) {
            super(output, completableFuture, blockTagProvider);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.copy(class_3481.field_15471, class_3489.field_15537);
            this.copy(class_3481.field_15499, class_3489.field_15555);
            this.copy(class_3481.field_15494, class_3489.field_15552);
            this.copy(class_3481.field_15502, class_3489.field_15557);
            this.copy(class_3481.field_15468, class_3489.field_15534);
            this.copy(class_3481.field_17619, class_3489.field_17620);
            this.copy(class_3481.field_15462, class_3489.field_15528);
            this.copy(PineBlockTags.PINE_LOGS, PineItemTags.PINE_LOGS);
            this.copy(class_3481.field_23210, class_3489.field_23212);
            this.copy(class_3481.field_15477, class_3489.field_15540);
            this.copy(class_3481.field_15503, class_3489.field_15558);
            this.copy(class_3481.field_15491, class_3489.field_15550);
            this.copy(class_3481.field_25147, class_3489.field_40858);
            this.valueLookupBuilder(class_3489.field_15536).method_71554((Object)PineItems.PINE_BOAT);
            this.valueLookupBuilder(class_3489.field_38080).method_71554((Object)PineItems.PINE_CHEST_BOAT);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineNlLanguageProvider
    extends FabricLanguageProvider {
        protected PineNlLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "nl_nl", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(PineBlocks.PINE_PLANKS, "Dennenhouten planken");
            builder.add(PineBlocks.PINE_SAPLING, "Dennenzaailing");
            builder.add(PineBlocks.PINE_LOG, "Dennenstam");
            builder.add(PineBlocks.STRIPPED_PINE_LOG, "Gestripte dennenstam");
            builder.add(PineBlocks.PINE_WOOD, "Dennenhout");
            builder.add(PineBlocks.STRIPPED_PINE_WOOD, "Gestripte dennenhout");
            builder.add(PineBlocks.PINE_LEAVES, "Dennennaalden");
            builder.add(PineBlocks.PINE_SIGN, "Dennenhouten bord");
            builder.add(PineBlocks.PINE_HANGING_SIGN, "Dennenhouten hangbord");
            builder.add(PineBlocks.PINE_PRESSURE_PLATE, "Dennenhouten drukplaat");
            builder.add(PineBlocks.PINE_TRAPDOOR, "Dennenhouten valluik");
            builder.add(PineBlocks.PINE_STAIRS, "Dennenhouten trap");
            builder.add(PineBlocks.POTTED_PINE_SAPLING, "Opgepotte dennenzaailing");
            builder.add(PineBlocks.PINE_BUTTON, "Dennenhouten knop");
            builder.add(PineBlocks.PINE_SLAB, "Dennenhouten plaat");
            builder.add(PineBlocks.PINE_FENCE_GATE, "Dennenhouten poort");
            builder.add(PineBlocks.PINE_FENCE, "Dennenhouten hek");
            builder.add(PineBlocks.PINE_DOOR, "Dennenhouten deur");
            builder.add(PineItems.PINE_BOAT, "Dennenhouten boot");
            builder.add(PineItems.PINE_CHEST_BOAT, "Dennenhouten boot met kist");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineEnLanguageProvider
    extends FabricLanguageProvider {
        protected PineEnLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(PineBlocks.PINE_PLANKS, "Pine Planks");
            builder.add(PineBlocks.PINE_SAPLING, "Pine Sapling");
            builder.add(PineBlocks.PINE_LOG, "Pine Log");
            builder.add(PineBlocks.STRIPPED_PINE_LOG, "Stripped Pine Log");
            builder.add(PineBlocks.PINE_WOOD, "Pine Wood");
            builder.add(PineBlocks.STRIPPED_PINE_WOOD, "Stripped Pine Wood");
            builder.add(PineBlocks.PINE_LEAVES, "Pine Leaves");
            builder.add(PineBlocks.PINE_SIGN, "Pine Sign");
            builder.add(PineBlocks.PINE_HANGING_SIGN, "Pine Hanging Sign");
            builder.add(PineBlocks.PINE_PRESSURE_PLATE, "Pine Pressure Plate");
            builder.add(PineBlocks.PINE_TRAPDOOR, "Pine Trapdoor");
            builder.add(PineBlocks.PINE_STAIRS, "Pine Stairs");
            builder.add(PineBlocks.POTTED_PINE_SAPLING, "Potted Pine Sapling");
            builder.add(PineBlocks.PINE_BUTTON, "Pine Button");
            builder.add(PineBlocks.PINE_SLAB, "Pine Slab");
            builder.add(PineBlocks.PINE_FENCE_GATE, "Pine Fence Gate");
            builder.add(PineBlocks.PINE_FENCE, "Pine Fence");
            builder.add(PineBlocks.PINE_DOOR, "Pine Door");
            builder.add(PineItems.PINE_BOAT, "Pine Boat");
            builder.add(PineItems.PINE_CHEST_BOAT, "Pine Chest Boat");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PinePlacedFeatureProvider
    extends FabricDynamicRegistryProvider {
        public PinePlacedFeatureProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
            super(dataOutput, registryLookupFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.PINE_ON_SNOW);
            entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.PINE_CHECKED);
            entries.add(registries.method_46762(class_7924.field_41245), PinePlacedFeatures.MEGA_PINE_CHECKED);
        }

        public static void bootstrap(class_7891<class_6796> registerable) {
            class_7871 registryLookup = registerable.method_46799(class_7924.field_41239);
            class_6817.method_39737(registerable, PinePlacedFeatures.PINE_ON_SNOW, (class_6880)registryLookup.method_46747(PineConfiguredFeatures.PINE), List.of(class_6794.method_39628((class_2350)class_2350.field_11036, (class_6646)class_6646.method_38877((class_6646)class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_27879})), (int)8), class_6658.method_39618((class_6646)class_6646.method_43288((class_2382)class_2350.field_11033.method_62675(), (class_2248[])new class_2248[]{class_2246.field_10491, class_2246.field_27879}))));
            class_6817.method_40370(registerable, PinePlacedFeatures.PINE_CHECKED, (class_6880)registryLookup.method_46747(PineConfiguredFeatures.PINE), (class_6797[])new class_6797[]{class_6817.method_40365((class_2248)PineBlocks.PINE_SAPLING)});
            class_6817.method_40370(registerable, PinePlacedFeatures.MEGA_PINE_CHECKED, (class_6880)registryLookup.method_46747(PineConfiguredFeatures.MEGA_PINE), (class_6797[])new class_6797[]{class_6817.method_40365((class_2248)PineBlocks.PINE_SAPLING)});
        }

        public String method_10321() {
            return "Placed Features";
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineConfiguredFeatureProvider
    extends FabricDynamicRegistryProvider {
        public PineConfiguredFeatureProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
            super(dataOutput, registryLookupFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            entries.add(registries.method_46762(class_7924.field_41239), PineConfiguredFeatures.PINE);
            entries.add(registries.method_46762(class_7924.field_41239), PineConfiguredFeatures.MEGA_PINE);
        }

        public String method_10321() {
            return "Configured Features";
        }

        public static void bootstrap(class_7891<class_2975<?, ?>> registerable) {
            class_6803.method_39708(registerable, PineConfiguredFeatures.PINE, (class_3031)class_3031.field_24134, (class_3037)new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)PineBlocks.PINE_LOG), (class_5141)new class_5140(6, 4, 0), (class_4651)class_4651.method_38432((class_2248)PineBlocks.PINE_LEAVES), (class_4647)new class_4649((class_6017)class_6016.method_34998((int)1), (class_6017)class_6016.method_34998((int)1), (class_6017)class_6019.method_35017((int)3, (int)4)), (class_5201)new class_5204(2, 0, 2)).method_27376((List)ImmutableList.of((Object)((Object)new AlterTopTrunkTreeDecorator((class_4651)class_4651.method_38432((class_2248)PineBlocks.STRIPPED_PINE_LOG), (class_6017)class_6019.method_35017((int)-1, (int)2), 0.9f, 0.5f)))).method_27374().method_23445());
            class_6803.method_39708(registerable, PineConfiguredFeatures.MEGA_PINE, (class_3031)class_3031.field_24134, (class_3037)new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)PineBlocks.PINE_LOG), (class_5141)new class_5214(13, 2, 14), (class_4651)class_4651.method_38432((class_2248)PineBlocks.PINE_LEAVES), (class_4647)new class_5210((class_6017)class_6016.method_34998((int)0), (class_6017)class_6016.method_34998((int)0), (class_6017)class_6019.method_35017((int)3, (int)7)), (class_5201)new class_5204(1, 1, 2)).method_27376((List)ImmutableList.of((Object)new class_4658((class_4651)class_4651.method_38432((class_2248)class_2246.field_10520)), (Object)((Object)new AlterTopTrunkTreeDecorator((class_4651)class_4651.method_38432((class_2248)PineBlocks.STRIPPED_PINE_LOG), (class_6017)class_6019.method_35017((int)-1, (int)3), 0.9f, 0.5f)))).method_23445());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineRecipeProvider
    extends FabricRecipeProvider {
        public PineRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected class_2446 method_62766(class_7225.class_7874 registryLookup, class_8790 exporter) {
            return new class_2446(this, registryLookup, exporter){

                public void method_10419() {
                    this.method_33535(PINE_FAMILY, class_7701.field_40183);
                    this.method_24477((class_1935)PineBlocks.PINE_PLANKS, PineItemTags.PINE_LOGS, 4);
                    this.method_24476((class_1935)PineBlocks.PINE_WOOD, (class_1935)PineBlocks.PINE_LOG);
                    this.method_24476((class_1935)PineBlocks.STRIPPED_PINE_WOOD, (class_1935)PineBlocks.STRIPPED_PINE_LOG);
                    this.method_24478((class_1935)PineItems.PINE_BOAT, (class_1935)PineBlocks.PINE_PLANKS);
                    this.method_42754((class_1935)PineItems.PINE_CHEST_BOAT, (class_1935)PineItems.PINE_BOAT);
                    this.method_46208((class_1935)PineItems.PINE_HANGING_SIGN, (class_1935)PineBlocks.STRIPPED_PINE_LOG);
                }
            };
        }

        public String method_10321() {
            return "Recipes";
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineBlockLootTableProvider
    extends FabricBlockLootTableProvider {
        protected PineBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            this.method_46025(PineBlocks.PINE_PLANKS);
            this.method_46025(PineBlocks.PINE_SAPLING);
            this.method_46025(PineBlocks.PINE_LOG);
            this.method_46025(PineBlocks.STRIPPED_PINE_LOG);
            this.method_46025(PineBlocks.PINE_WOOD);
            this.method_46025(PineBlocks.STRIPPED_PINE_WOOD);
            this.method_46025(PineBlocks.PINE_SIGN);
            this.method_46025(PineBlocks.PINE_HANGING_SIGN);
            this.method_46025(PineBlocks.PINE_PRESSURE_PLATE);
            this.method_46025(PineBlocks.PINE_TRAPDOOR);
            this.method_46025(PineBlocks.PINE_STAIRS);
            this.method_46025(PineBlocks.PINE_BUTTON);
            this.method_46025(PineBlocks.PINE_FENCE_GATE);
            this.method_46025(PineBlocks.PINE_FENCE);
            this.method_46023(PineBlocks.POTTED_PINE_SAPLING);
            this.method_45994(PineBlocks.PINE_SLAB, arg_0 -> ((PineBlockLootTableProvider)this).method_45980(arg_0));
            this.method_45994(PineBlocks.PINE_DOOR, arg_0 -> ((PineBlockLootTableProvider)this).method_46022(arg_0));
            this.method_45994(PineBlocks.PINE_LEAVES, block -> this.method_45986((class_2248)block, PineBlocks.PINE_SAPLING, field_40605));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PineModelProvider
    extends FabricModelProvider {
        public PineModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 generator) {
            generator.method_25650(PineBlocks.PINE_PLANKS).method_33522(PINE_FAMILY);
            generator.method_25676(PineBlocks.PINE_LOG).method_25730(PineBlocks.PINE_LOG).method_25728(PineBlocks.PINE_WOOD);
            generator.method_25676(PineBlocks.STRIPPED_PINE_LOG).method_25730(PineBlocks.STRIPPED_PINE_LOG).method_25728(PineBlocks.STRIPPED_PINE_WOOD);
            generator.method_46190(PineBlocks.STRIPPED_PINE_LOG, PineBlocks.PINE_HANGING_SIGN, PineBlocks.PINE_WALL_HANGING_SIGN);
            generator.method_65407(PineBlocks.PINE_SAPLING, PineBlocks.POTTED_PINE_SAPLING, class_4910.class_4913.field_22840);
            generator.method_65408(PineBlocks.PINE_LEAVES, class_4946.field_23049, -7488922);
        }

        public void generateItemModels(class_4915 generator) {
            generator.method_65442(PineItems.PINE_BOAT, class_4943.field_22938);
            generator.method_65442(PineItems.PINE_CHEST_BOAT, class_4943.field_22938);
        }
    }
}

