/*
 * Decompiled with CFR 0.152.
 */
package smsk.smoothscroll.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import smsk.smoothscroll.SmoothSc;
import smsk.smoothscroll.cfg.CfgValue;
import smsk.smoothscroll.cfg.CfgValueBuilder;
import smsk.smoothscroll.cfg.NewConfig;

public class SmScCfg
extends NewConfig {
    public static final float format = 2.41f;
    public static float hotbarSmoothness;
    public static boolean hotbarRollover;
    public static float chatSmoothness;
    public static float chatOpeningSmoothness;
    public static float chatAmount;
    public static float suggestionWindowSmoothness;
    public static float suggestionWindowAmount;
    public static float creativeScreenSmoothness;
    public static float entryListSmoothness;
    public static double entryListAmount;
    public static float textSmoothness;
    public static float textAmount;
    public static float textMargin;
    public static boolean textCustomUpdate;
    public static boolean enableMaskDebug;
    static CfgValue template;

    public SmScCfg() {
        super("smoothscroll.json", template);
    }

    @Override
    void intoVariables() {
        hotbarSmoothness = ((Float)this.root.get("Hotbar").get("Smoothness").getValue()).floatValue() / 100.0f;
        hotbarRollover = (Boolean)this.root.get("Hotbar").get("Rollover").getValue();
        chatSmoothness = ((Float)this.root.get("Chat").get("Smoothness").getValue()).floatValue() / 100.0f;
        chatOpeningSmoothness = ((Float)this.root.get("Chat").get("Opening Smoothness").getValue()).floatValue() / 100.0f;
        chatAmount = ((Float)this.root.get("Chat").get("Scrolling Speed").getValue()).floatValue();
        suggestionWindowSmoothness = ((Float)this.root.get("Chat").get("Suggestion Smoothness").getValue()).floatValue() / 100.0f;
        suggestionWindowAmount = ((Float)this.root.get("Chat").get("Suggestion Speed").getValue()).floatValue();
        creativeScreenSmoothness = ((Float)this.root.get("Creative Screen").get("Smoothness").getValue()).floatValue() / 100.0f;
        entryListSmoothness = ((Float)this.root.get("Entry List").get("Smoothness").getValue()).floatValue() / 100.0f;
        entryListAmount = ((Float)this.root.get("Entry List").get("Speed").getValue()).floatValue();
        textSmoothness = ((Float)this.root.get("Text Input Field").get("Smoothness").getValue()).floatValue() / 100.0f;
        textAmount = ((Float)this.root.get("Text Input Field").get("Speed").getValue()).floatValue();
        textMargin = ((Float)this.root.get("Text Input Field").get("Cursor Margin").getValue()).floatValue();
        textCustomUpdate = (Boolean)this.root.get("Text Input Field").get("Custom Cursor Update").getValue();
        enableMaskDebug = (Boolean)this.root.get("Misc").get("Enable mask debug").getValue();
    }

    @Override
    void dataCorrectPermanent() {
        float prevFormat;
        Object object;
        if (this.rawRoot.get("cfgVersion").exists() && (object = this.rawRoot.get("cfgVersion").getValue()) instanceof Float) {
            Float cfgver = (Float)object;
            SmoothSc.print("Found old format entries in the config file, attempting to update them.");
            CfgValue a = this.rawRoot.get("hotbarSpeed");
            if (a.exists() && a.getValue() instanceof Float) {
                SmoothSc.print(a.getValue());
                if (cfgver.floatValue() < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Hotbar").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("chatSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver.floatValue() < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Chat").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("chatOpeningSpeed")).exists() && a.getValue() instanceof Float) {
                this.root.get("Chat").get("Opening Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("creativeScreenSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver.floatValue() < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                this.root.get("Creative Screen").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("entryListSpeed")).exists() && a.getValue() instanceof Float) {
                if (cfgver.floatValue() < 1.6f && ((Float)a.getValue()).floatValue() >= 1.0f) {
                    a.setValue(Float.valueOf(1.0f / ((Float)a.getValue()).floatValue()));
                }
                if (cfgver.floatValue() < 1.9f && ((Float)a.getValue()).floatValue() == 0.334f) {
                    a.setValue(Float.valueOf(0.5f));
                }
                this.root.get("Entry List").get("Smoothness").setValue(a.getValue());
            }
            if ((a = this.rawRoot.get("enableMaskDebug")).exists() && a.getValue() instanceof Float) {
                this.root.get("Chat").get("Smoothness").setValue(a.getValue());
            }
        }
        if ((double)(prevFormat = ((Float)this.root.get("Format").getValue()).floatValue()) < 2.4) {
            CfgValue merged = this.root.get("Hotbar");
            CfgValue raw = this.rawRoot.get("Hotbar");
            try {
                merged.get("Smoothness").setValue(Float.valueOf(((Float)raw.get("Smoothness").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            merged = this.root.get("Chat");
            raw = this.rawRoot.get("Chat");
            try {
                merged.get("Smoothness").setValue(Float.valueOf(((Float)raw.get("Smoothness").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                merged.get("Opening Smoothness").setValue(Float.valueOf(((Float)raw.get("Opening Speed").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                merged.get("Suggestion Smoothness").setValue(Float.valueOf(((Float)raw.get("Suggestion Smoothness").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            merged = this.root.get("Creative Screen");
            raw = this.rawRoot.get("Creative Screen");
            try {
                merged.get("Smoothness").setValue(Float.valueOf(((Float)raw.get("Smoothness").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            merged = this.root.get("Entry List");
            raw = this.rawRoot.get("Entry List");
            try {
                merged.get("Smoothness").setValue(Float.valueOf(((Float)raw.get("Smoothness").getValue()).floatValue() * 100.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((double)prevFormat < 2.41) {
            try {
                if (((Float)this.root.get("Chat").get("Suggestion Smoothness").getValue()).floatValue() == 5000.0f) {
                    this.root.get("Chat").get("Suggestion Smoothness").setValue(Float.valueOf(50.0f));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.root.get("Notes").defaultToTemp();
        this.root.get("Notes").saveTempValue();
        this.root.get("Format").defaultToTemp();
        this.root.get("Format").saveTempValue();
    }

    @Override
    void dataCorrectTemporary() {
        if (SmoothSc.isSmoothScrollingRefurbishedLoaded) {
            entryListSmoothness = 0.0f;
        }
    }

    @Override
    void problemReading() {
        super.problemReading();
        SmoothSc.print("There was a problem reading the config file. Using default values.");
    }

    @Override
    void problemWriting() {
        super.problemWriting();
        SmoothSc.print("There was a problem writing to the config file.");
    }

    @Override
    void fileNotFound() {
        super.fileNotFound();
        SmoothSc.print("There is no config file, creating a new one.");
    }

    static {
        template = new CfgValueBuilder("root", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Notes", new ArrayList<String>(Arrays.asList("Smoothness values are in %. Scrolling speed values are in pixels.", "0 % means animation off (no smoothness) and bigger values mean slower animation speed (high smoothness).", "Press F3+T in a world to update the config.", "To access config ingame, use the mod modmenu."))).build(), new CfgValueBuilder("Hotbar", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(20.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Rollover", true).build()))).build(), new CfgValueBuilder("Chat", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Opening Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Scrolling Speed", Float.valueOf(0.0f)).minMax(0.0f, 100.0f).step(1.0).map(0.0, "Auto").format("%s: %s px").build(), new CfgValueBuilder("Suggestion Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Suggestion Speed", Float.valueOf(30.0f)).minMax(0.0f, 100.0f).step(1.0).format("%s: %s px").map(0, "Auto").build()))).build(), new CfgValueBuilder("Creative Screen", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build()))).build(), new CfgValueBuilder("Entry List", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Speed", Float.valueOf(30.0f)).minMax(0.0f, 100.0f).step(1.0).format("%s: %s px").map(0, "Auto").build()))).build(), new CfgValueBuilder("Text Input Field", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Smoothness", Float.valueOf(50.0f)).minMax(0.0f, 100.0f).map(0, "Off").map(100, "No Scrolling").step(1.0).format("%s: %s %%").build(), new CfgValueBuilder("Speed", Float.valueOf(100.0f)).minMax(0.0f, 300.0f).step(1.0).format("%s: %s px").map(0, "Auto").build(), new CfgValueBuilder("Cursor Margin", Float.valueOf(10.0f)).minMax(0.0f, 100.0f).step(1.0).format("%s: %s %%").disableWhen(val -> (Boolean)val.get((String)"..").get((String)"Custom Cursor Update").temporaryValue == false).build(), new CfgValueBuilder("Custom Cursor Update", true).tooltip("Disable this if you're having problems when you move the cursor with arrows").build()))).build(), new CfgValueBuilder("Misc", new ArrayList<CfgValue>(Arrays.asList(new CfgValueBuilder("Enable mask debug", false).build()))).build(), new CfgValueBuilder("Format", Float.valueOf(2.41f)).build()))).build();
    }
}

