/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.autorespawn.event;

import com.blocklegend001.autorespawn.ModConfigs;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autorespawn", value={Dist.CLIENT})
public class AutoRespawnEvent {
    private static long deathTime = 0L;
    private static boolean wasDead = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.player.isDeadOrDying()) {
            AutoRespawnEvent.handleRespawn(client);
        } else {
            AutoRespawnEvent.resetDeathState();
        }
    }

    private static void handleRespawn(Minecraft client) {
        if (!wasDead) {
            deathTime = System.currentTimeMillis();
            wasDead = true;
        }
        if (System.currentTimeMillis() - deathTime >= (long)ModConfigs.respawnDelay && client.player != null) {
            client.player.respawn();
            client.setScreen(null);
            AutoRespawnEvent.resetDeathState();
        }
    }

    private static void resetDeathState() {
        deathTime = 0L;
        wasDead = false;
    }
}

