/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.autorespawn.event;

import com.blocklegend001.autorespawn.ModConfigs;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="autorespawn")
public class AutoRespawnEvent {
    private static long deathTime = 0L;
    private static boolean wasDead = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.player.isDeadOrDying()) {
            AutoRespawnEvent.handleRespawn(client);
        } else {
            AutoRespawnEvent.resetDeathState();
        }
    }

    private static void handleRespawn(Minecraft client) {
        if (!wasDead) {
            deathTime = System.currentTimeMillis();
            wasDead = true;
        }
        if (System.currentTimeMillis() - deathTime >= (long)ModConfigs.respawnDelay && client.player != null) {
            client.player.respawn();
            client.setScreen(null);
            AutoRespawnEvent.resetDeathState();
        }
    }

    private static void resetDeathState() {
        deathTime = 0L;
        wasDead = false;
    }
}

