/*
 * Decompiled with CFR 0.152.
 */
package glowredman.defaultserverlist.mixins.early;

import glowredman.defaultserverlist.Config;
import java.util.List;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerList.class})
public abstract class ServerListMixin {
    @Shadow
    @Final
    private List<ServerData> servers;

    @Shadow
    public abstract void saveServerList();

    @Inject(at={@At(value="TAIL")}, method={"loadServerList()V"})
    private void removeDuplicateServers(CallbackInfo ci) {
        this.servers.removeIf(o -> {
            String s1 = o.serverIP.replace("http://", "").replace("https://", "").replace(":25565", "");
            for (ServerData s2 : Config.SERVERS) {
                if (!s1.equals(s2.serverIP.replace("http://", "").replace("https://", "").replace(":25565", ""))) continue;
                return true;
            }
            return false;
        });
        for (ServerData s : Config.SERVERS) {
            s.field_78841_f = false;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"saveServerList()V"})
    private void saveDefaultServerList(CallbackInfo ci) {
        if (Config.allowModifications) {
            String[] newServers = new String[Config.SERVERS.size()];
            for (int i = 0; i < newServers.length; ++i) {
                ServerData data = Config.SERVERS.get(i);
                newServers[i] = data.serverIP + '|' + data.serverName;
            }
            Config.saveServers(newServers);
        }
    }

    @Overwrite
    public ServerData getServerData(int index) {
        if (index < this.servers.size()) {
            return this.servers.get(index);
        }
        return Config.SERVERS.get(index - this.servers.size());
    }

    @Overwrite
    public void removeServerData(int index) {
        if (index < this.servers.size()) {
            this.servers.remove(index);
        } else if (Config.allowModifications) {
            Config.SERVERS.remove(index - this.servers.size());
        }
    }

    @Overwrite
    public int countServers() {
        return this.servers.size() + Config.SERVERS.size();
    }

    @Overwrite
    public void swapServers(int index1, int index2) {
        if (index1 < this.servers.size() && index2 < this.servers.size()) {
            ServerData serverdata = this.getServerData(index1);
            this.servers.set(index1, this.getServerData(index2));
            this.servers.set(index2, serverdata);
            this.saveServerList();
        } else if (index1 >= this.servers.size() && index2 >= this.servers.size()) {
            ServerData serverdata = this.getServerData(index1);
            Config.SERVERS.set(index1 - this.servers.size(), this.getServerData(index2));
            Config.SERVERS.set(index2 - this.servers.size(), serverdata);
            this.saveDefaultServerList(null);
        }
    }

    @Overwrite
    public void func_147413_a(int index, ServerData data) {
        if (index < this.servers.size()) {
            this.servers.set(index, data);
        }
    }
}

